package com.xforceplus.ultraman.sdk.infra;

/**
 *  trait present a wrapped object
 *
 * @param <T>
 */
public interface Wrapped<T> {

    T getOriginObject();

    default T getOrigin() {
        if (Wrapped.class.isAssignableFrom(getOriginObject().getClass())) {
            return ((Wrapped<T>) getOriginObject()).getOrigin();
        }

        return getOriginObject();
    }
}
