package com.xforceplus.ultraman.sdk.infra.logging;

/**
 * Error Constants Path like this format
 * xxx.xxx.xxx
 */
public enum LoggingPattern {
    
    EVENT_PUBLISH_ERROR("oqs.event.publish.error"),
    
    GENERAL_UTILS_ERROR("oqs.general.utils.error"),
    
    DATA_PROCESS_ERROR("oqs.data.process.error"),
    
    METADATA_SDK_CONFIG_ERROR("oqs.metadata.sdkconfig.error"),
    
    SINGLE_QUERY_ERROR("oqs.query.one.error"),
    
    EXPORT_ERROR("oqs.export.error"),
    
    IMPORT_ERROR("oqs.import.error"),
    
    CONDITION_QUERY_ERROR("oqs.query.condition.error"),
    
    GRAPHQL_DATA_FETCHER_ERROR("oqs.graphql.fetcher.error"),
    
    INDEX_QUERY_ERROR("oqs.query.index.error"),
    
    INDEX_SYNC_ERROR("oqs.index.sync.error"),
    
    INDEX_OPERATION_ERROR("oqs.index.operation.error"),

    INDEX_PREPARE_ERROR("oqs.index.prepare.error"),
    
    BUSINESS_OPERATION_ERROR("oqs.business.operation.error"),

    ENDPOINT_OPERATION_ERROR("oqs.endpoint.operation.error"),
    
    CDC_PROCESS_ERROR("oqs.cdc.process.error"),
    
    UNKNOWN_ERROR("oqs.unknown.error");
    
    String pattern;


    LoggingPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getPattern() {
        return pattern;
    }
}
