package com.xforceplus.ultraman.sdk.infra.query;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

/**
 * Lazy Fetch
 *
 * @param <S>
 * @param <T>
 * @param <U>
 */
public class LazyFetchIterator<S, T, U> implements Iterator<U> {

    private Function<S, List<T>> source;

    private BiFunction<S, T, S> stepFunction;

    private Predicate<S> beforePredicate;

    private Predicate<List<T>> afterPredicate;

    private Function<T, U> transfomer;

    private LinkedList<T> buffer = new LinkedList<>();

    private boolean fetchNext;

    private S initS;

    private S currentS;

    public LazyFetchIterator(
            S init
            , Function<S, List<T>> source
            , BiFunction<S, T, S> stepFunction
            , Predicate<S> beforePredicate
            , Predicate<List<T>> afterPredicate
            , Function<T, U> transformer
    ) {
        this.source = source;
        this.stepFunction = stepFunction;
        this.beforePredicate = beforePredicate;
        this.afterPredicate = afterPredicate;
        this.initS = init;
        this.currentS = init;
        this.transfomer = transformer;

        fetchNext();
    }

    @Override
    public boolean hasNext() {
        return !buffer.isEmpty();
    }

    @Override
    public U next() {
        if (!buffer.isEmpty()) {
            U u = getNext();

            if (buffer.size() < 2 && fetchNext) {
                fetchNext();
            }

            return u;
        }

        throw new NoSuchElementException();
    }

    private void fetchNext() {
        List<T> result = source.apply(currentS);
        fetchNext = !afterPredicate.test(result);
        buffer.addAll(result);
        currentS = stepFunction.apply(currentS, buffer.isEmpty() ? null : buffer.getLast());
        if (fetchNext) {
            fetchNext = beforePredicate.test(currentS);
        }
    }

    private U getNext() {
        return transfomer.apply(buffer.pop());
    }
}
