package com.xforceplus.ultraman.sdk.infra.utils;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Optional;

public class CommonUtils {

    public static String getNodeName(){
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            NetworkInterface byInetAddress = NetworkInterface.getByInetAddress(inetAddress);

            byte[] mac = byInetAddress.getHardwareAddress();

            String macName = null;
            if (mac != null) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < mac.length; i++) {
                    sb.append(String.format("%02X%s", mac[i], (i < mac.length - 1) ? "-" : ""));
                }

                macName = sb.toString();
            }

            return inetAddress.getHostAddress() + ":" + Optional.ofNullable(macName).orElse("UNKNOWN");
        } catch (Throwable throwable) {
            return "UNKNOWN";
        }
    }

}
