/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.sdk.infra.query;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public class LazyFetchIterator<S, T, U>
implements Iterator<U> {
    private Function<S, List<T>> source;
    private BiFunction<S, T, S> stepFunction;
    private Predicate<S> beforePredicate;
    private Predicate<List<T>> afterPredicate;
    private Function<T, U> transfomer;
    private LinkedList<T> buffer = new LinkedList();
    private boolean fetchNext;
    private S initS;
    private S currentS;

    public LazyFetchIterator(S init, Function<S, List<T>> source, BiFunction<S, T, S> stepFunction, Predicate<S> beforePredicate, Predicate<List<T>> afterPredicate, Function<T, U> transformer) {
        this.source = source;
        this.stepFunction = stepFunction;
        this.beforePredicate = beforePredicate;
        this.afterPredicate = afterPredicate;
        this.initS = init;
        this.currentS = init;
        this.transfomer = transformer;
        this.fetchNext();
    }

    @Override
    public boolean hasNext() {
        return !this.buffer.isEmpty();
    }

    @Override
    public U next() {
        if (!this.buffer.isEmpty()) {
            U u = this.getNext();
            if (this.buffer.size() < 2 && this.fetchNext) {
                this.fetchNext();
            }
            return u;
        }
        throw new NoSuchElementException();
    }

    private void fetchNext() {
        List<T> result = this.source.apply(this.currentS);
        this.fetchNext = !this.afterPredicate.test(result);
        this.buffer.addAll(result);
        this.currentS = this.stepFunction.apply(this.currentS, this.buffer.isEmpty() ? null : (Object)this.buffer.getLast());
        if (this.fetchNext) {
            this.fetchNext = this.beforePredicate.test(this.currentS);
        }
    }

    private U getNext() {
        return this.transfomer.apply(this.buffer.pop());
    }
}

