/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.sdk.infra.utils;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CompletableFutureUtils {
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("failAfter-%d").build());

    public static <T> CompletableFuture<List<T>> sequence(List<CompletableFuture<T>> coms) {
        return CompletableFuture.allOf(coms.toArray(new CompletableFuture[0])).thenApply(v -> coms.stream().map(CompletableFuture::join).collect(Collectors.toList()));
    }

    public static <T> CompletableFuture<T> failAfter(Duration duration) {
        CompletableFuture promise = new CompletableFuture();
        scheduler.schedule(() -> {
            TimeoutException ex = new TimeoutException("Timeout after " + duration);
            return promise.completeExceptionally(ex);
        }, duration.toMillis(), TimeUnit.MILLISECONDS);
        return promise;
    }

    public static <T> CompletableFuture<T> within(CompletableFuture<T> future, Duration duration) {
        CompletableFuture<T> timeout = CompletableFutureUtils.failAfter(duration);
        return future.applyToEither((CompletionStage)timeout, Function.identity());
    }
}

