package com.xforceplus.ultraman.sdk.infra.base;

import io.vavr.Tuple;
import io.vavr.Tuple2;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * appId resolver to handler app like
 *  a:ss,sdsd:0
 */
public class AppIdResolver {


    private final static String APP_DELIMITER = ",";

    private final static String ENV_DELIMITER = ":";

    public static List<Tuple2<String, String>> getAppAndEnvTuple(String appIds, String defaultEnv) {

        if(StringUtils.isEmpty(appIds)){
            throw new RuntimeException("AppId Configuration is Missing");
        }

        String[] appIdList = appIds.split(APP_DELIMITER);
        return Stream.of(appIdList).map(x -> {
            String[] envAndApp = x.split(ENV_DELIMITER);
            String env = defaultEnv;
            if(envAndApp.length > 1){
                env = envAndApp[1];
            }
            String appId = envAndApp[0];
            return Tuple.of(appId, env);
        }).collect(Collectors.toList());
    }
}
