package com.xforceplus.ultraman.sdk.infra.event.impl;

import com.xforceplus.ultraman.sdk.infra.CacheLike;
import com.xforceplus.ultraman.sdk.infra.Refreshable;
import com.xforceplus.ultraman.sdk.infra.event.EventEngine;
import com.xforceplus.ultraman.sdk.infra.event.EventPublisher;
import com.xforceplus.ultraman.sdk.infra.event.UltramanLifecycle;
import com.xforceplus.ultraman.sdk.infra.logging.LoggingPattern;
import com.xforceplus.ultraman.sdk.infra.logging.LoggingUtils;
import lombok.extern.slf4j.Slf4j;

import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

import static com.xforceplus.ultraman.sdk.infra.logging.LoggingUtils.logErrorPattern;

/**
 * TODO
 */
@Slf4j
public class EventEngineImpl implements EventEngine {

    private Map<UltramanLifecycle, List<Refreshable>> mapping = new ConcurrentHashMap<>();

    private EventPublisher eventPublisher;

    public EventEngineImpl(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void register(UltramanLifecycle lifecycle, Refreshable refreshable) {
        List<Refreshable> list = mapping.getOrDefault(lifecycle, new ArrayList<>());
        list.add(refreshable);
        mapping.put(lifecycle, list);
    }

    /**
     * TODO
     *
     * @param lifecycle
     * @param payload
     */
    @Override
    public void trigger(UltramanLifecycle lifecycle, Object payload) {
        log.info("Trigger Refresh");
        List<Refreshable> refreshables = mapping.get(lifecycle);
     
        List<Refreshable> checkRefreshable = Optional.ofNullable(refreshables)
                .orElseGet(Collections::emptyList);
        
        List<List<Refreshable>> list = buildDependsTree(new ArrayList<>(checkRefreshable));

        list.forEach(x -> {
            x.forEach(y ->  {
                try {
                    y.onRefresh(payload);
                } catch (Throwable throwable) {
                    logErrorPattern(log, LoggingPattern.UNKNOWN_ERROR, throwable);
                }
            });
        });
    }

    @Override
    public void refresh(UltramanLifecycle lifecycle) {
        List<Refreshable> refreshables = mapping.get(lifecycle);

        List<Refreshable> checkRefreshable = Optional.ofNullable(refreshables)
                .orElseGet(Collections::emptyList);
        
        checkRefreshable.stream().filter(x -> x instanceof CacheLike).forEach(x -> {
            try {
                ((CacheLike) x).refreshCache();
            } catch (Throwable throwable) {
                logErrorPattern(log, LoggingPattern.UNKNOWN_ERROR, throwable);
            }
        });
        
    }

    private List<List<Refreshable>> buildDependsTree(List<Refreshable> refreshables) {
        List<List<Refreshable>> layered = new LinkedList<>();
        List<Refreshable> baseRefreshable = refreshables.stream().filter(x -> x.getDependsOn().isEmpty()).collect(Collectors.toList());
        layered.add(baseRefreshable);
        refreshables.removeAll(baseRefreshable);
        buildRecursive(refreshables, layered);
        return layered;
    }

    private void buildRecursive(List<Refreshable> refreshables, List<List<Refreshable>> layered) {
      while(!refreshables.isEmpty()) {
          List<Refreshable> nextLayer = refreshables.stream().filter(x -> {
              return layered.stream().flatMap(y -> y.stream()).anyMatch(l -> x.getDependsOn().contains(l.getClass()));
          }).collect(Collectors.toList());
          if(nextLayer.isEmpty() && !refreshables.isEmpty()) {
              throw new RuntimeException("Refreshable Dependencies is error still got " + refreshables);
          } 
          
          layered.add(nextLayer);
          refreshables.removeAll(nextLayer);
      }
    }

    @Override
    public void publish(Object object) {
        if (eventPublisher != null) {
            eventPublisher.publishEvent(object);
        }
    }
}
