package com.xforceplus.ultraman.sdk.infra.exceptions;

public class OperationFailedException extends RuntimeException {

    private final static String msg = "%s failed, Reason %s";

    public static String getMsg(String... args) {
        if (args != null && args.length > 1) {
            String type = args[0];
            String reason = args[0];
            return String.format(msg, type, reason);
        } else if (args != null && args.length > 0) {
            String arg = args[0];
            return String.format(msg, arg, "unknown");
        } else {
            return String.format(msg, "unknown", "unknown");
        }
    }

    public OperationFailedException(String message) {
        super(message);
    }
}
