package com.xforceplus.ultraman.sdk.infra.logging;

import java.util.HashMap;
import java.util.Map;

import static com.xforceplus.ultraman.sdk.infra.logging.LoggingPattern.*;

/**
 * TODO
 */
public class LoggingMessageProvider {
    
    private static Map<LoggingPattern, String> templateMapping = new HashMap<>();
    
    static {
        templateMapping.put(EVENT_PUBLISH_ERROR, "[EventPublisherErr][%s]");
        templateMapping.put(GENERAL_UTILS_ERROR, "[GeneralUtilsErr][%s]");
        templateMapping.put(SINGLE_QUERY_ERROR, "[SelectOneErr][%s]");
        templateMapping.put(CONDITION_QUERY_ERROR, "[SelectConditionErr][%s]");
        templateMapping.put(UNKNOWN_ERROR, "[UnHandledErr][%s]");
        templateMapping.put(INDEX_SYNC_ERROR, "[IndexSyncErr][%s]");
        templateMapping.put(INDEX_PREPARE_ERROR, "[IndexPrepareErr][%s]");
        templateMapping.put(INDEX_OPERATION_ERROR, "[IndexOperationErr][%s]");
        templateMapping.put(DATA_PROCESS_ERROR, "[DataProcessErr][%s]");
        templateMapping.put(METADATA_SDK_CONFIG_ERROR, "[MetadataSDKConfigErr][%s]");
        templateMapping.put(INDEX_QUERY_ERROR, "[IndexQueryErr][%s]");
        templateMapping.put(BUSINESS_OPERATION_ERROR, "[BusinessOperationErr][%s]");
        templateMapping.put(EXPORT_ERROR, "[ExportErr][%s]");
        templateMapping.put(CDC_PROCESS_ERROR, "[CDCProcessErr][%s]");
        templateMapping.put(GRAPHQL_DATA_FETCHER_ERROR, "[GRAPHQL][%s]");
    }
    
    public static String getTemplate(LoggingPattern pattern) {
        return templateMapping.get(pattern);
    }
}
