package com.xforceplus.ultraman.sdk.infra.logging;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

import java.util.function.Supplier;

public class LoggingUtils {

    public static void logErrorPattern(Logger log, LoggingPattern pattern, Supplier<String> extraSupplier, Throwable throwable) {
        logErrorPattern(log, pattern, extraSupplier.get(), throwable);
    }

    public static void logErrorPattern(Logger log, LoggingPattern pattern, Supplier<String> errMsgSupplier) {
        String errMsg = "";
        try {
            errMsg = errMsgSupplier.get();
        } catch (Throwable throwable) {
            log.error("[InnerError]:ErrMsgSupplierGetError", throwable);
        }
        logErrorPattern(log, pattern, "", errMsg);
    }

    public static void logErrorPattern(Logger log, LoggingPattern pattern, Supplier<String> extraSupplier, String errMsg) {
        String extraStr = "";
        try {
            extraStr = extraSupplier.get();
        } catch (Throwable throwable) {
            log.error("[InnerError]:ExtraSupplierGetError", throwable);
        }
        logErrorPattern(log, pattern, extraStr, errMsg);
    }

    public static void logErrorPattern(Logger log, LoggingPattern pattern, Throwable throwable) {
        logErrorPattern(log, pattern, "", throwable);
    }

    public static void logErrorPattern(Logger log, LoggingPattern pattern, String errMsg) {
        logErrorPattern(log, pattern, "", errMsg);
    }

    public static void logErrorPattern(Logger log, LoggingPattern pattern, String extraStr, String errMsg) {
        String template = LoggingMessageProvider.getTemplate(pattern);
        if(StringUtils.isEmpty(template)) {
            template = LoggingMessageProvider.getTemplate(LoggingPattern.UNKNOWN_ERROR);
        }
        log.error(String.format(template, extraStr).concat(" {}"), errMsg);
    }

    public static void logErrorPattern(Logger log, LoggingPattern pattern, String extraStr, Throwable throwable) {
        String template = LoggingMessageProvider.getTemplate(pattern);
        if(StringUtils.isEmpty(template)) {
            template = LoggingMessageProvider.getTemplate(LoggingPattern.UNKNOWN_ERROR);
        }
        log.error(String.format(template, extraStr), throwable);
    }
}
