package com.xforceplus.ultraman.sdk.infra.utils;

import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encoder;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * escape helper
 */
public class EscapeUtils {

    private static Encoder encoder = ESAPI.encoder();


    /**
     * mapping
     * <p>
     * &    &amp;
     * <    &lt;
     * >    &gt;
     * "    &quot;
     * '    &#x27;
     *
     * @param src
     * @return
     */

    private static Map<Character, String> replaceMapping = new HashMap<>();

    static {
        replaceMapping.put('&', "&amp;");
        replaceMapping.put('<', "&lt;");
        replaceMapping.put('>', "&gt;");
        replaceMapping.put('"', "&quot;");
        replaceMapping.put('\'', "&#x27;");
    }


    public static String escapeHtmlSimple(String src) {
        if(src != null) {
            StringBuilder sb = new StringBuilder();
            src.chars().forEach(i -> {
                String s = replaceMapping.get((char)i);
                if(s == null) {
                    sb.append((char)i);
                } else {
                    sb.append(s);
                }
            });
            return sb.toString();
        } else {
            return null;
        }
    }
}
