package com.xforceplus.ultraman.sdk.infra.utils;

import org.apache.commons.lang3.StringUtils;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2023/8/3 16:53
 * Description:
 * History:
 */
public class TenantUtil {

    public static final String POUND = "#";
    public static final String AT = "@";
    public static final String UNDERSCORE = "_";
    public static final String HYPHEN = "-";

    /**
     * 将租户代码中的特殊字符转换成下划线，包括#,@,-
     * @param tenantCode
     * @return
     */
    public static String convertSpecialSymbolToUnderscore(String tenantCode) {
        if(StringUtils.isEmpty(tenantCode)) {
            return tenantCode;
        }
        if(tenantCode.contains(AT)) {
            tenantCode = StringUtils.replace(tenantCode, AT, UNDERSCORE);
        }
        if(tenantCode.contains(POUND)) {
            tenantCode = StringUtils.replace(tenantCode, POUND, UNDERSCORE);
        }
        if(tenantCode.contains(HYPHEN)) {
            tenantCode = StringUtils.replace(tenantCode, HYPHEN, UNDERSCORE);
        }
        return tenantCode;
    }

    /**
     * 将租户代码中的特殊字符转换成中划线，包括#,@,_
     * @param tenantCode
     * @return
     */
    public static String convertSpecialSymbolToHyphen(String tenantCode) {
        if(StringUtils.isEmpty(tenantCode)) {
            return tenantCode;
        }
        if(tenantCode.contains(AT)) {
            tenantCode = StringUtils.replace(tenantCode, AT, HYPHEN);
        }
        if(tenantCode.contains(POUND)) {
            tenantCode = StringUtils.replace(tenantCode, POUND, HYPHEN);
        }
        if(tenantCode.contains(UNDERSCORE)) {
            tenantCode = StringUtils.replace(tenantCode, UNDERSCORE, HYPHEN);
        }
        return tenantCode;
    }
}
