/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.sdk.infra.event.impl;

import com.xforceplus.ultraman.sdk.infra.CacheLike;
import com.xforceplus.ultraman.sdk.infra.Refreshable;
import com.xforceplus.ultraman.sdk.infra.event.EventEngine;
import com.xforceplus.ultraman.sdk.infra.event.EventPublisher;
import com.xforceplus.ultraman.sdk.infra.event.UltramanLifecycle;
import com.xforceplus.ultraman.sdk.infra.logging.LoggingPattern;
import com.xforceplus.ultraman.sdk.infra.logging.LoggingUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventEngineImpl
implements EventEngine {
    private static final Logger log = LoggerFactory.getLogger(EventEngineImpl.class);
    private Map<UltramanLifecycle, List<Refreshable>> mapping = new ConcurrentHashMap<UltramanLifecycle, List<Refreshable>>();
    private EventPublisher eventPublisher;

    public EventEngineImpl(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void register(UltramanLifecycle lifecycle, Refreshable refreshable) {
        List list = this.mapping.getOrDefault((Object)lifecycle, new ArrayList());
        list.add(refreshable);
        this.mapping.put(lifecycle, list);
    }

    @Override
    public void trigger(UltramanLifecycle lifecycle, Object payload) {
        log.info("Trigger Refresh");
        List<Refreshable> refreshables = this.mapping.get((Object)lifecycle);
        List checkRefreshable = Optional.ofNullable(refreshables).orElseGet(Collections::emptyList);
        List<List<Refreshable>> list = this.buildDependsTree(new ArrayList<Refreshable>(checkRefreshable));
        list.forEach(x -> x.forEach(y -> {
            try {
                y.onRefresh(payload);
            }
            catch (Throwable throwable) {
                LoggingUtils.logErrorPattern(log, LoggingPattern.UNKNOWN_ERROR, throwable);
            }
        }));
    }

    @Override
    public void refresh(UltramanLifecycle lifecycle) {
        List<Refreshable> refreshables = this.mapping.get((Object)lifecycle);
        List checkRefreshable = Optional.ofNullable(refreshables).orElseGet(Collections::emptyList);
        checkRefreshable.stream().filter(x -> x instanceof CacheLike).forEach(x -> {
            try {
                ((CacheLike)((Object)x)).refreshCache();
            }
            catch (Throwable throwable) {
                LoggingUtils.logErrorPattern(log, LoggingPattern.UNKNOWN_ERROR, throwable);
            }
        });
    }

    private List<List<Refreshable>> buildDependsTree(List<Refreshable> refreshables) {
        LinkedList<List<Refreshable>> layered = new LinkedList<List<Refreshable>>();
        List baseRefreshable = refreshables.stream().filter(x -> x.getDependsOn().isEmpty()).collect(Collectors.toList());
        layered.add(baseRefreshable);
        refreshables.removeAll(baseRefreshable);
        this.buildRecursive(refreshables, layered);
        return layered;
    }

    private void buildRecursive(List<Refreshable> refreshables, List<List<Refreshable>> layered) {
        while (!refreshables.isEmpty()) {
            List nextLayer = refreshables.stream().filter(x -> layered.stream().flatMap(y -> y.stream()).anyMatch(l -> x.getDependsOn().contains(l.getClass()))).collect(Collectors.toList());
            if (nextLayer.isEmpty() && !refreshables.isEmpty()) {
                throw new RuntimeException("Refreshable Dependencies is error still got " + refreshables);
            }
            layered.add(nextLayer);
            refreshables.removeAll(nextLayer);
        }
    }

    @Override
    public void publish(Object object) {
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent(object);
        }
    }
}

