/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.sdk.infra.base.id;

import com.xforceplus.ultraman.sdk.infra.base.id.LongIdGenerator;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.zip.CRC32;
import javax.sql.DataSource;

public class MysqlLongIdGenerator
implements LongIdGenerator {
    private static final int SUCCESS = 1;
    private static final String DEFAULT_NAMESPACE = "d";
    private static final String KEY_PREIFX = "i";
    private static final String DEFAULT_TABLE_NAME = "idinfo";
    private static final String DEFAULT_VARIABLE_NAME = "xplatid";
    private static final long DEFAULT_SLOT_SIZE = 1000L;
    private static final int TIMEOUT_SECOND = 3;
    private static final String INCR_SQL = "UPDATE %s SET barrel = @%s := JSON_SET(barrel, '$.\"%s\"', cast(IFNULL(barrel->>'$.\"%s\"', 0) as SIGNED) + 1) where id = %d";
    private static final String RESET_SQL = "UPDATE %s SET barrel = JSON_REMOVE(barrel, '$.\"%s\"') where id = %d";
    private static final String READ_VARIABLE_SQL = "select JSON_UNQUOTE(JSON_EXTRACT(@%s,'$.\"%s\"')) AS v";
    private DataSource dataSource;
    private String tableName;
    private String variableName;
    private long slotSize;

    private MysqlLongIdGenerator() {
    }

    @Override
    public Long next() {
        return this.next(DEFAULT_NAMESPACE);
    }

    @Override
    public Long next(String nameSpace) {
        this.checkNs(nameSpace);
        try {
            return this.doMysqlIncr(this.wrapperNs(nameSpace));
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @Override
    public void reset() {
        this.reset(DEFAULT_NAMESPACE);
    }

    @Override
    public void reset(String nameSpace) {
        this.checkNs(nameSpace);
        try {
            if (!this.doMysqlReset(this.wrapperNs(nameSpace))) {
                if (DEFAULT_NAMESPACE == nameSpace) {
                    throw new IllegalStateException(String.format("Cannot reset the default namespace correctly.", new Object[0]));
                }
                throw new IllegalStateException(String.format("Cannot reset the %s namespace correctly.", nameSpace));
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @Override
    public boolean supportNameSpace() {
        return true;
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    @Override
    public boolean isPartialOrder() {
        return true;
    }

    private void checkNs(String ns) {
        if (ns == null || ns.isEmpty()) {
            throw new IllegalArgumentException("Invalid namespace.");
        }
    }

    private long doMysqlIncr(String ns) throws SQLException {
        long slot = this.calculateSlot(ns);
        String incrSql = String.format(INCR_SQL, this.tableName, this.variableName, ns, ns, slot);
        long newValue = 0L;
        try (Connection conn = this.dataSource.getConnection();){
            block36: {
                conn.setAutoCommit(false);
                try (Statement st = conn.createStatement();){
                    st.setQueryTimeout(3);
                    int size = st.executeUpdate(incrSql);
                    if (size != 1) break block36;
                    String readSql = String.format(READ_VARIABLE_SQL, this.variableName, ns);
                    try (ResultSet rs = st.executeQuery(readSql);){
                        rs.next();
                        newValue = rs.getLong(1);
                    }
                }
            }
            conn.commit();
        }
        return newValue;
    }

    private boolean doMysqlReset(String ns) throws SQLException {
        int size;
        long slot = this.calculateSlot(ns);
        String resetSql = String.format(RESET_SQL, this.tableName, ns, slot);
        try (Connection conn = this.dataSource.getConnection();){
            conn.setAutoCommit(false);
            try (Statement st = conn.createStatement();){
                st.setQueryTimeout(3);
                size = st.executeUpdate(resetSql);
            }
            conn.commit();
        }
        return 1 == size;
    }

    /*
     * Exception decompiling
     */
    private long readMysqlSlotSize() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String wrapperNs(String ns) {
        return String.format("%s_%s", KEY_PREIFX, ns);
    }

    private long calculateSlot(String key) {
        CRC32 crc32 = new CRC32();
        byte[] bytes = key.getBytes(StandardCharsets.UTF_8);
        crc32.update(bytes);
        long value = crc32.getValue();
        long slot = value % this.slotSize;
        if (slot == 0L) {
            return slot + 1L;
        }
        return slot;
    }

    public static final class Builder {
        private DataSource dataSource;
        private String tableName = "idinfo";
        private String variableName = "xplatid";
        private long slotSize = 1000L;

        private Builder() {
        }

        public static Builder anMysqlLongIdGenerator() {
            return new Builder();
        }

        public Builder withDataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public Builder withTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder withVariableName(String variableName) {
            this.variableName = variableName;
            return this;
        }

        public Builder withSlotSize(long slotSize) {
            this.slotSize = slotSize;
            return this;
        }

        public MysqlLongIdGenerator build() {
            MysqlLongIdGenerator mysqlLongIdGenerator = new MysqlLongIdGenerator();
            mysqlLongIdGenerator.dataSource = this.dataSource;
            mysqlLongIdGenerator.slotSize = this.slotSize;
            mysqlLongIdGenerator.variableName = this.variableName;
            mysqlLongIdGenerator.tableName = this.tableName;
            long size = 0L;
            try {
                size = mysqlLongIdGenerator.readMysqlSlotSize();
            }
            catch (SQLException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            if (this.slotSize > size) {
                throw new RuntimeException(String.format("The %s slot is set up, but there are only %s slots.", this.slotSize, size));
            }
            return mysqlLongIdGenerator;
        }
    }
}

