/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.sdk.infra.base.id.node;

import com.xforceplus.ultraman.sdk.infra.base.id.node.NodeIdGenerator;
import com.xforceplus.ultraman.sdk.infra.base.timerwheel.ITimerWheel;
import com.xforceplus.ultraman.sdk.infra.base.timerwheel.TimeoutNotification;
import com.xforceplus.ultraman.sdk.infra.base.timerwheel.TimerWheel;
import com.xforceplus.ultraman.sdk.infra.lifecycle.SimpleLifecycle;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.ThreadLocalRandom;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlNodeIdGenerator
implements NodeIdGenerator,
SimpleLifecycle {
    private final Logger logger = LoggerFactory.getLogger(MysqlNodeIdGenerator.class);
    private static final long DEFAULT_HEARTBEAT_INTERVAL_MS = 3600000L;
    private static final String DEFAULT_TABLE_NAME = "nodeid";
    private static final int DEFAULT_MAX_ID = 1023;
    private static final String ID_FIELD = "id";
    private static final String HEARTBEAT_FIELD = "heartbeat";
    private DataSource ds;
    private ITimerWheel<NodeId> heartBearWheel;
    private String tableName;
    private long heartbeatIntervalMs;
    private int maxId = 1023;
    private NodeId nodeId;

    public DataSource getDs() {
        return this.ds;
    }

    public String getTableName() {
        return this.tableName;
    }

    public long getHeartbeatIntervalMs() {
        return this.heartbeatIntervalMs;
    }

    public int getMaxId() {
        return this.maxId;
    }

    @Override
    public void init() throws Exception {
        NodeId[] nodeIds = this.initNodeInfo();
        NodeId nodeId = this.findNodeInfo(nodeIds);
        if (nodeId == null) {
            throw new IllegalStateException("A valid node number could not be found.");
        }
        this.nodeId = nodeId;
        this.logger.info("Initialization successful, current node number is {}.", (Object)nodeId.getId());
        this.heartBearWheel = new TimerWheel<NodeId>(new HeartbeatTimeoutNotification());
        this.heartBearWheel.add(this.nodeId, this.heartbeatIntervalMs);
    }

    @Override
    public void destroy() throws Exception {
        this.heartBearWheel.destroy();
    }

    @Override
    public Integer next() {
        if (this.nodeId == null) {
            throw new IllegalStateException("The node number generator has not yet generated the number.");
        }
        return this.nodeId.getId() - 1;
    }

    private NodeId[] initNodeInfo() throws SQLException {
        int size = this.maxId + 1;
        ArrayList<NodeId> nodeIds = new ArrayList<NodeId>(size);
        try (Connection conn = this.ds.getConnection();
             Statement st = conn.createStatement();
             ResultSet rs = st.executeQuery(String.format("SELECT %s, %s FROM %s LIMIT 0, %d", ID_FIELD, HEARTBEAT_FIELD, this.tableName, size));){
            while (rs.next()) {
                nodeIds.add(new NodeId(rs.getInt(ID_FIELD), rs.getLong(HEARTBEAT_FIELD)));
            }
        }
        if (nodeIds.size() != size) {
            throw new IllegalStateException(String.format("The expected number of available ids was %d, but it is now %d.", size, nodeIds.size()));
        }
        return (NodeId[])nodeIds.stream().toArray(NodeId[]::new);
    }

    private NodeId findNodeInfo(NodeId[] nodeIds) throws SQLException {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        NodeId[] useNodeIds = nodeIds;
        while (useNodeIds.length != 0) {
            int selectNumber = random.nextInt(0, useNodeIds.length);
            NodeId selectNodeId = nodeIds[selectNumber];
            if (this.takeUp(selectNodeId, false)) {
                return selectNodeId;
            }
            useNodeIds = this.eliminate(nodeIds, selectNodeId);
            if (!this.logger.isInfoEnabled()) continue;
            this.logger.info("The use of the node information {} was abandoned because the occupation failed.", (Object)selectNodeId);
        }
        return null;
    }

    private boolean takeUp(NodeId selectNodeId, boolean focus) throws SQLException {
        if (!focus && !this.isTimeout(selectNodeId)) {
            return false;
        }
        boolean ok = false;
        long newHeartbeatTimeMs = System.currentTimeMillis();
        try (Connection conn = this.ds.getConnection();
             PreparedStatement ps = conn.prepareStatement(String.format("UPDATE %s SET %s=? WHERE %s=? AND %s=?", this.tableName, HEARTBEAT_FIELD, ID_FIELD, HEARTBEAT_FIELD));){
            ps.setLong(1, newHeartbeatTimeMs);
            ps.setInt(2, selectNodeId.getId());
            ps.setLong(3, selectNodeId.getHeartbeat());
            boolean success = true;
            ok = ps.executeUpdate() == 1;
        }
        selectNodeId.setHeartbeat(newHeartbeatTimeMs);
        return ok;
    }

    private boolean isTimeout(NodeId selectNodeId) {
        long dur = System.currentTimeMillis() - selectNodeId.getHeartbeat();
        if (dur <= 0L) {
            return false;
        }
        return dur > this.heartbeatIntervalMs;
    }

    private NodeId[] eliminate(NodeId[] nodeIds, NodeId targetInfo) {
        ArrayList<NodeId> surviveNodeIds = new ArrayList<NodeId>(nodeIds.length - 1);
        for (NodeId nodeId : nodeIds) {
            if (nodeId.equals(targetInfo)) continue;
            surviveNodeIds.add(nodeId);
        }
        return (NodeId[])surviveNodeIds.stream().toArray(NodeId[]::new);
    }

    private class HeartbeatTimeoutNotification
    implements TimeoutNotification<NodeId> {
        private HeartbeatTimeoutNotification() {
        }

        @Override
        public long notice(NodeId nodeId) {
            boolean result = false;
            try {
                result = MysqlNodeIdGenerator.this.takeUp(nodeId, true);
            }
            catch (SQLException e) {
                MysqlNodeIdGenerator.this.logger.error(e.getMessage(), (Throwable)e);
            }
            return MysqlNodeIdGenerator.this.heartbeatIntervalMs;
        }
    }

    public static final class Builder {
        private DataSource ds;
        private String tableName = "nodeid";
        private long heartbeatIntervalMs = 3600000L;
        private int maxId = 1023;

        private Builder() {
        }

        public static Builder anMysqlNodeIdGenerator() {
            return new Builder();
        }

        public Builder withDataSource(DataSource ds) {
            this.ds = ds;
            return this;
        }

        public Builder withTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder withHeartbeatIntervalMs(long heartbeatIntervalMs) {
            this.heartbeatIntervalMs = heartbeatIntervalMs;
            return this;
        }

        public Builder withMaxId(int maxId) {
            this.maxId = maxId;
            return this;
        }

        public MysqlNodeIdGenerator build() throws Exception {
            MysqlNodeIdGenerator mysqlNodeIdGenerator = new MysqlNodeIdGenerator();
            mysqlNodeIdGenerator.heartbeatIntervalMs = this.heartbeatIntervalMs;
            mysqlNodeIdGenerator.tableName = this.tableName;
            mysqlNodeIdGenerator.ds = this.ds;
            mysqlNodeIdGenerator.maxId = this.maxId;
            mysqlNodeIdGenerator.init();
            return mysqlNodeIdGenerator;
        }
    }

    private static class NodeId {
        private int id;
        private long heartbeat;

        public NodeId(int id, long heartbeat) {
            this.id = id;
            this.heartbeat = heartbeat;
        }

        public int getId() {
            return this.id;
        }

        public long getHeartbeat() {
            return this.heartbeat;
        }

        public void setHeartbeat(long heartbeat) {
            this.heartbeat = heartbeat;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NodeId)) {
                return false;
            }
            NodeId nodeId = (NodeId)o;
            return this.getId() == nodeId.getId();
        }

        public int hashCode() {
            return Objects.hash(this.getId());
        }

        public String toString() {
            return new StringJoiner(", ", NodeId.class.getSimpleName() + "[", "]").add("heartbeat=" + this.heartbeat).add("id=" + this.id).toString();
        }
    }
}

