/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.sdk.infra.base.timerwheel;

import com.xforceplus.ultraman.sdk.infra.base.thread.ExecutorHelper;
import com.xforceplus.ultraman.sdk.infra.base.timerwheel.ITimerWheel;
import com.xforceplus.ultraman.sdk.infra.base.timerwheel.TimeoutNotification;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class MultipleTimerWheel<T>
implements ITimerWheel<T> {
    private static final int DEFAULT_SLOT_NUMBER = 512;
    private static final int DEFAULT_SECOND_SLOT_NUMBER = 60;
    private static final int DEFAULT_THIRD_SLOT_NUMBER = 60;
    private static final int DEFAULT_FOURTH_SLOT_NUMBER = 24;
    private static final int DEFAULT_DURATION = 100;
    private final TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    private boolean initTick = true;
    private final long duration;
    private final long secondDuration;
    private final long thirdDuration;
    private final long fourthDuration;
    private final TimeoutNotification<T> notification;
    private final int slotNumber;
    private final List<Slot> workWheel;
    private final List<Slot> secondWheel;
    private final List<Slot> thirdWheel;
    private final List<Slot> fourthWheel;
    private final List<List<Slot>> wheelList;
    private final ExecutorService worker;
    private int currentSlot;
    private int secondCurrentSlot;
    private int thirdCurrentSlot;
    private int fourthCurrentSlot;
    private final Map<T, int[]> removeHelp;

    public MultipleTimerWheel(TimeoutNotification<T> notification) {
        this(-1, -1L, notification);
    }

    public MultipleTimerWheel(int slotNumber, long duration, TimeoutNotification<T> notification) {
        this.duration = duration <= 0L ? 100L : duration;
        this.slotNumber = slotNumber <= 3 ? 512 : slotNumber;
        this.notification = notification == null ? t -> 0L : notification;
        this.secondDuration = this.duration * (long)this.slotNumber;
        this.thirdDuration = this.secondDuration * 60L;
        this.fourthDuration = this.thirdDuration * 60L;
        this.currentSlot = 0;
        this.secondCurrentSlot = 0;
        this.thirdCurrentSlot = 0;
        this.fourthCurrentSlot = 0;
        this.workWheel = new ArrayList<Slot>(this.slotNumber);
        this.secondWheel = new ArrayList<Slot>(60);
        this.thirdWheel = new ArrayList<Slot>(60);
        this.fourthWheel = new ArrayList<Slot>(24);
        this.wheelList = new ArrayList<List<Slot>>(4);
        this.removeHelp = new ConcurrentHashMap<T, int[]>(16);
        this.initWheelList();
        this.worker = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1000), ExecutorHelper.buildNameThreadFactory("time-wheel", true));
        this.worker.submit(new PointTask());
    }

    @Override
    public void destroy() throws Exception {
        this.worker.shutdownNow();
    }

    private void initWheelList() {
        int i;
        for (i = 0; i < this.slotNumber; ++i) {
            this.workWheel.add(new Slot());
        }
        for (i = 0; i < 60; ++i) {
            this.secondWheel.add(new Slot());
        }
        for (i = 0; i < 60; ++i) {
            this.thirdWheel.add(new Slot());
        }
        for (i = 0; i < 24; ++i) {
            this.fourthWheel.add(new Slot());
        }
        this.wheelList.add(this.workWheel);
        this.wheelList.add(this.secondWheel);
        this.wheelList.add(this.thirdWheel);
        this.wheelList.add(this.fourthWheel);
    }

    @Override
    public void add(T target, long timeout) {
        if (target == null) {
            throw new NullPointerException("Target object is null!");
        }
        if (timeout <= 0L) {
            return;
        }
        long specialTimeout = timeout;
        if (specialTimeout <= this.duration) {
            specialTimeout = this.duration * 2L;
        }
        int round = -1;
        int current = this.currentSlot;
        int actuallyWheel = this.calculateActuallyWheel(specialTimeout, current);
        int actuallySlotIndex = this.calculateActuallySlot(specialTimeout, actuallyWheel, current);
        if (actuallyWheel < 3) {
            round = 0;
        } else if (actuallyWheel == 3) {
            round = (int)(specialTimeout / (this.fourthDuration * 24L));
        }
        long remainingTime = this.calculateRemainingTime(specialTimeout, current);
        Slot slot = this.wheelList.get(actuallyWheel).get(actuallySlotIndex);
        slot.addElement(target, round, remainingTime);
        this.removeHelp.put(target, new int[]{actuallyWheel, actuallySlotIndex});
    }

    @Override
    public void add(T target, Date expireDate) {
        this.add(target, expireDate.getTime() - System.currentTimeMillis());
    }

    @Override
    public boolean exist(T target) {
        return this.removeHelp.containsKey(target);
    }

    @Override
    public void remove(T target) {
        if (target == null) {
            return;
        }
        int[] value = this.removeHelp.remove(target);
        if (value != null) {
            this.wheelList.get(value[0]).get(value[1]).remove(target);
        }
    }

    @Override
    public int size() {
        return this.removeHelp.size();
    }

    private int calculateActuallyWheel(long specialTimeout, int current) {
        if (specialTimeout < this.secondDuration - (long)current * this.duration) {
            return 0;
        }
        if (this.secondDuration - (long)current * this.duration <= specialTimeout && specialTimeout < this.thirdDuration - (long)current * this.duration) {
            return 1;
        }
        if (this.thirdDuration - (long)current * this.duration <= specialTimeout && specialTimeout < this.fourthDuration - (long)current * this.duration) {
            return 2;
        }
        if (specialTimeout >= this.fourthDuration) {
            return 3;
        }
        return -1;
    }

    private int calculateActuallySlot(long timeout, int actuallyWheel, int current) {
        int actuallySlot = actuallyWheel == 0 ? (timeout % this.duration == 0L ? (int)(((long)current + timeout / this.duration) % (long)this.slotNumber) : (int)(((long)current + timeout / this.duration + 1L) % (long)this.slotNumber)) : (actuallyWheel == 1 ? (int)(((long)this.secondCurrentSlot + (timeout + (long)current * this.duration) / this.secondDuration) % 60L) : (actuallyWheel == 2 ? (int)(((long)this.thirdCurrentSlot + (timeout + (long)current * this.duration) / this.thirdDuration) % 60L) : (actuallyWheel == 3 ? (int)(((long)this.fourthCurrentSlot + (timeout + (long)current * this.duration) / this.fourthDuration) % 24L) : -1)));
        return actuallySlot;
    }

    private long calculateRemainingTime(long specialTimeout, int current) {
        long remainingTime = 0L;
        if (specialTimeout < this.secondDuration - (long)current * this.duration) {
            remainingTime = 0L;
        } else if (this.secondDuration - (long)current * this.duration < specialTimeout && specialTimeout < this.thirdDuration - (long)current * this.duration) {
            remainingTime = (specialTimeout + (long)current * this.duration) % this.secondDuration;
        } else if (this.thirdDuration - (long)current * this.duration < specialTimeout && specialTimeout < this.fourthDuration - (long)current * this.duration) {
            remainingTime = (specialTimeout + (long)current * this.duration) % this.thirdDuration;
        } else if (specialTimeout - (long)current * this.duration > this.fourthDuration) {
            remainingTime = (specialTimeout + (long)current * this.duration) % this.fourthDuration;
        }
        return remainingTime;
    }

    private Slot getWorkWheelSlotAndTickWheel() {
        Slot slot;
        if (this.initTick) {
            this.initTick = false;
            this.currentSlot = (this.currentSlot + 1) % this.slotNumber;
            slot = this.workWheel.get(0);
        } else if (this.currentSlot != 0) {
            slot = this.tickWorkWheel();
        } else if (++this.secondCurrentSlot % 60 != 0) {
            this.secondCurrentSlot %= 60;
            slot = this.tickSecondWheel();
        } else if (++this.thirdCurrentSlot % 60 != 0) {
            this.thirdCurrentSlot %= 60;
            this.secondCurrentSlot %= 60;
            slot = this.tickThirdWheel();
        } else {
            this.thirdCurrentSlot %= 60;
            this.secondCurrentSlot %= 60;
            slot = this.tickFourthWheel();
        }
        return slot;
    }

    private Slot tickWorkWheel() {
        Slot slot = this.workWheel.get(this.currentSlot);
        this.currentSlot = (this.currentSlot + 1) % this.slotNumber;
        return slot;
    }

    private Slot tickSecondWheel() {
        Slot secondSlot = this.secondWheel.get(this.secondCurrentSlot);
        this.wheelDeliver(secondSlot, this.removeHelp);
        Slot slot = this.workWheel.get(this.currentSlot);
        this.currentSlot = (this.currentSlot + 1) % this.slotNumber;
        return slot;
    }

    private Slot tickThirdWheel() {
        Slot secondSlot = this.secondWheel.get(this.secondCurrentSlot);
        this.wheelDeliver(secondSlot, this.removeHelp);
        Slot thirdSlot = this.thirdWheel.get(this.thirdCurrentSlot);
        this.wheelDeliver(thirdSlot, this.removeHelp);
        Slot slot = this.workWheel.get(this.currentSlot);
        this.currentSlot = (this.currentSlot + 1) % this.slotNumber;
        return slot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Slot tickFourthWheel() {
        Slot secondSlot = this.secondWheel.get(this.secondCurrentSlot);
        this.wheelDeliver(secondSlot, this.removeHelp);
        Slot thirdSlot = this.thirdWheel.get(this.thirdCurrentSlot);
        this.wheelDeliver(thirdSlot, this.removeHelp);
        this.fourthCurrentSlot = (this.fourthCurrentSlot + 1) % 24;
        Slot fourthSlot = this.fourthWheel.get(this.fourthCurrentSlot);
        if (fourthSlot.elements.size() > 0) {
            fourthSlot.lock.lock();
            try {
                Iterator iterator = fourthSlot.elements.iterator();
                while (iterator.hasNext()) {
                    Element element = (Element)iterator.next();
                    if (element.getRound() <= 0) {
                        Object target = element.getTarget();
                        long timeout = element.getRemainingTime();
                        this.removeHelp.remove(target);
                        if (timeout == 0L) {
                            timeout = this.duration;
                        }
                        this.add(target, timeout);
                        iterator.remove();
                        continue;
                    }
                    element.reduceRound();
                }
            }
            finally {
                fourthSlot.lock.unlock();
            }
        }
        Slot slot = this.workWheel.get(this.currentSlot);
        this.currentSlot = (this.currentSlot + 1) % this.slotNumber;
        return slot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wheelDeliver(Slot slot, Map<T, int[]> removeHelp) {
        if (slot.elements.size() > 0) {
            slot.lock.lock();
            try {
                for (Element element : slot.elements) {
                    removeHelp.remove(element.getTarget());
                    if (element.getRemainingTime() > 0L) {
                        this.add(element.getTarget(), element.getRemainingTime());
                        continue;
                    }
                    this.add(element.getTarget(), this.duration);
                }
                slot.elements.clear();
            }
            finally {
                slot.lock.unlock();
            }
        }
    }

    private class PointTask
    implements Runnable {
        private PointTask() {
        }

        @Override
        public void run() {
            do {
                long startTime = System.currentTimeMillis();
                Slot slot = MultipleTimerWheel.this.getWorkWheelSlotAndTickWheel();
                slot.expire();
                try {
                    long endTime = System.currentTimeMillis();
                    long sleepTime = MultipleTimerWheel.this.duration - (endTime - startTime);
                    if (sleepTime <= 0L) continue;
                    MultipleTimerWheel.this.timeUnit.sleep(sleepTime);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            } while (!Thread.interrupted());
        }
    }

    private class Slot {
        private final List<Element> elements = new LinkedList<Element>();
        private final Lock lock = new ReentrantLock();

        private Slot() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addElement(T obj, int round, long remainingTime) {
            Element element = new Element(obj, round, remainingTime);
            this.lock.lock();
            try {
                this.elements.add(element);
            }
            finally {
                this.lock.unlock();
            }
        }

        public void expire() {
            for (Element element : this.elements) {
                long resultTime = MultipleTimerWheel.this.notification.notice(element.getTarget());
                if (resultTime <= 0L) {
                    MultipleTimerWheel.this.removeHelp.remove(element.getTarget());
                    continue;
                }
                MultipleTimerWheel.this.add(element.getTarget(), resultTime);
            }
            this.elements.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(Object target) {
            int notFound = -1;
            int index = -1;
            this.lock.lock();
            try {
                for (int i = 0; i < this.elements.size(); ++i) {
                    if (!this.elements.get(i).getTarget().equals(target)) continue;
                    index = i;
                    break;
                }
                if (index > -1) {
                    this.elements.remove(index);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        public String toString() {
            return "Slot{elements=" + this.elements + '}';
        }
    }

    private class Element {
        private final T target;
        private int round;
        private long remainingTime;

        public Element(T target, int round, long remainingTime) {
            this.target = target;
            this.round = round;
            this.remainingTime = remainingTime;
        }

        public long getRemainingTime() {
            return this.remainingTime;
        }

        public T getTarget() {
            return this.target;
        }

        public int reduceRound() {
            return this.round--;
        }

        public int getRound() {
            return this.round;
        }

        public String toString() {
            return "Element{target=" + this.target + ", round=" + this.round + '}';
        }
    }
}

