/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.sdk.infra.event.impl;

import com.xforceplus.ultraman.sdk.infra.Refreshable;
import com.xforceplus.ultraman.sdk.infra.event.EventEngine;
import com.xforceplus.ultraman.sdk.infra.event.EventPublisher;
import com.xforceplus.ultraman.sdk.infra.event.UltramanLifecycle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventEngineImpl
implements EventEngine {
    private static final Logger log = LoggerFactory.getLogger(EventEngineImpl.class);
    private Map<UltramanLifecycle, List<Refreshable>> mapping = new ConcurrentHashMap<UltramanLifecycle, List<Refreshable>>();
    private EventPublisher eventPublisher;

    public EventEngineImpl(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void register(UltramanLifecycle lifecycle, Refreshable refreshable) {
        List list = this.mapping.getOrDefault((Object)lifecycle, new ArrayList());
        list.add(refreshable);
        this.mapping.put(lifecycle, list);
    }

    @Override
    public void trigger(UltramanLifecycle lifecycle, Object payload) {
        log.info("Trigger Refresh");
        List<Refreshable> refreshables = this.mapping.get((Object)lifecycle);
        Optional.ofNullable(refreshables).orElseGet(Collections::emptyList).forEach(x -> {
            try {
                x.onRefresh(payload);
            }
            catch (Throwable throwable) {
                log.error("{}", throwable);
            }
        });
    }

    @Override
    public void publish(Object object) {
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent(object);
        }
    }
}

