/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.sdk.infra.codec;

import org.owasp.esapi.codecs.AbstractCharacterCodec;
import org.owasp.esapi.codecs.PushbackSequence;

public class MySQLCodecCustom
extends AbstractCharacterCodec {
    public static final int MYSQL_MODE = 0;
    public static final int ANSI_MODE = 1;
    private Mode mode;

    @Deprecated
    public MySQLCodecCustom(int mode) {
        this.mode = Mode.findByKey(mode);
    }

    public MySQLCodecCustom(Mode mode) {
        this.mode = mode;
    }

    public String encodeCharacter(char[] immune, Character c) {
        char ch = c.charValue();
        if (this.containsCharacter(ch, immune)) {
            return "" + ch;
        }
        String hex = super.getHexForNonAlphanumeric(ch);
        if (hex == null) {
            return "" + ch;
        }
        switch (this.mode) {
            case ANSI: {
                return this.encodeCharacterANSI(c);
            }
            case STANDARD: {
                return this.encodeCharacterMySQL(c);
            }
        }
        return null;
    }

    private String encodeCharacterANSI(Character c) {
        if (c.charValue() == '\'') {
            return "''";
        }
        return "" + c;
    }

    private String encodeCharacterMySQL(Character c) {
        char ch = c.charValue();
        if (ch == '\u0000') {
            return "\\0";
        }
        if (ch == '\b') {
            return "\\b";
        }
        if (ch == '\t') {
            return "\\t";
        }
        if (ch == '\n') {
            return "\\n";
        }
        if (ch == '\r') {
            return "\\r";
        }
        if (ch == '\u001a') {
            return "\\Z";
        }
        if (ch == '\"') {
            return "\\\"";
        }
        if (ch == '\'') {
            return "\\'";
        }
        if (ch == '\\') {
            return "\\\\";
        }
        return "" + c;
    }

    public Character decodeCharacter(PushbackSequence<Character> input) {
        switch (this.mode) {
            case ANSI: {
                return this.decodeCharacterANSI(input);
            }
            case STANDARD: {
                return this.decodeCharacterMySQL(input);
            }
        }
        return null;
    }

    private Character decodeCharacterANSI(PushbackSequence<Character> input) {
        input.mark();
        Character first = (Character)input.next();
        if (first == null) {
            input.reset();
            return null;
        }
        if (first.charValue() != '\'') {
            input.reset();
            return null;
        }
        Character second = (Character)input.next();
        if (second == null) {
            input.reset();
            return null;
        }
        if (second.charValue() != '\'') {
            input.reset();
            return null;
        }
        return Character.valueOf('\'');
    }

    private Character decodeCharacterMySQL(PushbackSequence<Character> input) {
        input.mark();
        Character first = (Character)input.next();
        if (first == null) {
            input.reset();
            return null;
        }
        if (first.charValue() != '\\') {
            input.reset();
            return null;
        }
        Character second = (Character)input.next();
        if (second == null) {
            input.reset();
            return null;
        }
        if (second.charValue() == '0') {
            return Character.valueOf('\u0000');
        }
        if (second.charValue() == 'b') {
            return Character.valueOf('\b');
        }
        if (second.charValue() == 't') {
            return Character.valueOf('\t');
        }
        if (second.charValue() == 'n') {
            return Character.valueOf('\n');
        }
        if (second.charValue() == 'r') {
            return Character.valueOf('\r');
        }
        if (second.charValue() == 'Z') {
            return Character.valueOf('\u001a');
        }
        if (second.charValue() == '\"') {
            return Character.valueOf('\"');
        }
        if (second.charValue() == '%') {
            return Character.valueOf('%');
        }
        if (second.charValue() == '\'') {
            return Character.valueOf('\'');
        }
        if (second.charValue() == '\\') {
            return Character.valueOf('\\');
        }
        if (second.charValue() == '_') {
            return Character.valueOf('_');
        }
        return second;
    }

    public static enum Mode {
        ANSI(1),
        STANDARD(0);

        private int key;

        private Mode(int key) {
            this.key = key;
        }

        static Mode findByKey(int key) {
            for (Mode m : Mode.values()) {
                if (m.key != key) continue;
                return m;
            }
            String message = String.format("No Mode for %s. Valid references are MySQLStandard: %s or ANSI: %s", key, 0, 1);
            throw new IllegalArgumentException(message);
        }
    }
}

