/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.sdk.infra.utils;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigObject;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class ConfigUtils {
    private static final Logger log = LoggerFactory.getLogger(ConfigUtils.class);
    private static final String DATA_SOURCES = "dataSources";

    public static Config getMainDSConfig(Config config) {
        Object anyRef = config.getAnyRef(DATA_SOURCES);
        Config mainConfig = null;
        if (anyRef instanceof List) {
            List configList = config.getConfigList(DATA_SOURCES);
            if (((List)anyRef).isEmpty()) {
                throw new RuntimeException("\u81f3\u5c11\u914d\u7f6e\u4e00\u4e2a\u6570\u636e\u6e90");
            }
            mainConfig = (Config)configList.get(0);
        } else {
            ConfigObject configObject = config.getObject(DATA_SOURCES);
            if (configObject.isEmpty()) {
                throw new RuntimeException("\u81f3\u5c11\u914d\u7f6e\u4e00\u4e2a\u6570\u636e\u6e90");
            }
            if (config.hasPath("dataSources.master")) {
                List configList = config.getConfigList("dataSources.master");
                mainConfig = (Config)configList.get(0);
            }
        }
        if (mainConfig != null) {
            return mainConfig;
        }
        throw new RuntimeException("No Master datasource config");
    }

    public static List<Config> getDSConfigList(Config config) {
        Object anyRef = config.getAnyRef(DATA_SOURCES);
        if (anyRef instanceof List) {
            List configList = config.getConfigList(DATA_SOURCES);
            if (((List)anyRef).isEmpty()) {
                throw new RuntimeException("\u81f3\u5c11\u914d\u7f6e\u4e00\u4e2a\u6570\u636e\u6e90");
            }
            return configList;
        }
        ConfigObject configObject = config.getObject(DATA_SOURCES);
        if (configObject.isEmpty()) {
            throw new RuntimeException("\u81f3\u5c11\u914d\u7f6e\u4e00\u4e2a\u6570\u636e\u6e90");
        }
        if (config.hasPath("dataSources.master")) {
            List configList = config.getConfigList("dataSources.master");
            return configList;
        }
        throw new RuntimeException("No Master datasource config");
    }

    public static Config getConfig(Environment env) {
        String activeProfile;
        String baseName = "oqs-datasource";
        Config baseConfig = ConfigFactory.load((String)baseName);
        Config config = null;
        String[] activeProfiles = env.getActiveProfiles();
        if (activeProfiles.length > 0 && !(activeProfile = activeProfiles[0]).equalsIgnoreCase("DEFAULT") && !StringUtils.isEmpty((CharSequence)activeProfile)) {
            try {
                Config extend = ConfigFactory.load((String)"oqs-datasource-".concat(activeProfile));
                config = extend.withFallback((ConfigMergeable)baseConfig).resolve();
            }
            catch (Throwable throwable) {
                log.warn("Cannot find related {}", (Object)activeProfile);
            }
        }
        if (config == null) {
            config = baseConfig;
        }
        return config;
    }
}

