/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.sdk.infra.logging;

import com.xforceplus.ultraman.sdk.infra.logging.LoggingMessageProvider;
import com.xforceplus.ultraman.sdk.infra.logging.LoggingPattern;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class LoggingUtils {
    public static void logErrorPattern(Logger log, LoggingPattern pattern, Supplier<String> extraSupplier, Throwable throwable) {
        LoggingUtils.logErrorPattern(log, pattern, extraSupplier.get(), throwable);
    }

    public static void logErrorPattern(Logger log, LoggingPattern pattern, Supplier<String> errMsgSupplier) {
        String errMsg = "";
        try {
            errMsg = errMsgSupplier.get();
        }
        catch (Throwable throwable) {
            log.error("[InnerError]:ErrMsgSupplierGetError", throwable);
        }
        LoggingUtils.logErrorPattern(log, pattern, "", errMsg);
    }

    public static void logErrorPattern(Logger log, LoggingPattern pattern, Supplier<String> extraSupplier, String errMsg) {
        String extraStr = "";
        try {
            extraStr = extraSupplier.get();
        }
        catch (Throwable throwable) {
            log.error("[InnerError]:ExtraSupplierGetError", throwable);
        }
        LoggingUtils.logErrorPattern(log, pattern, extraStr, errMsg);
    }

    public static void logErrorPattern(Logger log, LoggingPattern pattern, Throwable throwable) {
        LoggingUtils.logErrorPattern(log, pattern, "", throwable);
    }

    public static void logErrorPattern(Logger log, LoggingPattern pattern, String errMsg) {
        LoggingUtils.logErrorPattern(log, pattern, "", errMsg);
    }

    public static void logErrorPattern(Logger log, LoggingPattern pattern, String extraStr, String errMsg) {
        String template = LoggingMessageProvider.getTemplate(pattern);
        if (StringUtils.isEmpty((CharSequence)template)) {
            template = LoggingMessageProvider.getTemplate(LoggingPattern.UNKNOWN_ERROR);
        }
        log.error(String.format(template, extraStr).concat(" {}"), (Object)errMsg);
    }

    public static void logErrorPattern(Logger log, LoggingPattern pattern, String extraStr, Throwable throwable) {
        String template = LoggingMessageProvider.getTemplate(pattern);
        if (StringUtils.isEmpty((CharSequence)template)) {
            template = LoggingMessageProvider.getTemplate(LoggingPattern.UNKNOWN_ERROR);
        }
        log.error(String.format(template, extraStr), throwable);
    }
}

