/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.sdk.infra.utils;

import org.apache.commons.lang3.StringUtils;

public final class NumberUtils {
    static long[] NEGATIVE_STEPS = new long[]{-10L, -100L, -1000L, -10000L, -100000L, -1000000L, -10000000L, -100000000L, -1000000000L, -10000000000L, -100000000000L, -1000000000000L, -10000000000000L, -100000000000000L, -1000000000000000L, -10000000000000000L, -100000000000000000L, -1000000000000000000L};
    static long[] POSITIVE_STEPS = new long[]{10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    private static final int INTEGER_VALUE_MAX_LEN = NumberUtils.size(Integer.MAX_VALUE);
    private static final int LONG_VALUE_MAX_LEN = NumberUtils.size(Long.MAX_VALUE);

    private NumberUtils() {
    }

    public static boolean isIntegerString(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return false;
        }
        for (char c : value.toCharArray()) {
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static int size(int value) {
        return NumberUtils.size((long)value);
    }

    public static int size(long value) {
        if (value == 0L) {
            return 1;
        }
        if (value < 0L) {
            for (int i = 0; i < NEGATIVE_STEPS.length; ++i) {
                if (value <= NEGATIVE_STEPS[i]) continue;
                return i + 1;
            }
            return NEGATIVE_STEPS.length + 1;
        }
        for (int i = 0; i < POSITIVE_STEPS.length; ++i) {
            if (value >= POSITIVE_STEPS[i]) continue;
            return i + 1;
        }
        return POSITIVE_STEPS.length + 1;
    }

    public static String zeroFill(int value) {
        return NumberUtils.zeroFill(value, INTEGER_VALUE_MAX_LEN);
    }

    public static String zeroFill(long value) {
        return NumberUtils.zeroFill(value, LONG_VALUE_MAX_LEN);
    }

    public static String zeroFill(int value, int maxLen) {
        return NumberUtils.zeroFill((long)value, maxLen);
    }

    public static String zeroFill(long value, int maxLen) {
        if (value < 0L) {
            throw new IllegalArgumentException("Cannot use negative numbers.");
        }
        int len = NumberUtils.size(value);
        int gap = maxLen - len;
        if (gap <= 0) {
            return Long.toString(value);
        }
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < gap; ++i) {
            buff.append('0');
        }
        buff.append(value);
        return buff.toString();
    }
}

