package com.xforceplus.ultraman.sdk.infra.event.impl;

import com.xforceplus.ultraman.sdk.infra.Refreshable;
import com.xforceplus.ultraman.sdk.infra.event.EventEngine;
import com.xforceplus.ultraman.sdk.infra.event.EventPublisher;
import com.xforceplus.ultraman.sdk.infra.event.UltramanLifecycle;
import lombok.extern.slf4j.Slf4j;
import org.apache.hc.client5.http.auth.AuthStateCacheable;

import java.util.*;
import java.util.concurrent.ConcurrentHashMap;

/**
 * TODO
 */
@Slf4j
public class EventEngineImpl implements EventEngine {

    private Map<UltramanLifecycle, List<Refreshable>> mapping = new ConcurrentHashMap<>();

    private EventPublisher eventPublisher;

    public EventEngineImpl(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void register(UltramanLifecycle lifecycle, Refreshable refreshable) {
        List<Refreshable> list = mapping.getOrDefault(lifecycle, new ArrayList<>());
        list.add(refreshable);
        mapping.put(lifecycle, list);
    }

    /**
     * TODO
     *
     * @param lifecycle
     * @param payload
     */
    @Override
    public void trigger(UltramanLifecycle lifecycle, Object payload) {
        log.info("Trigger Refresh");
        List<Refreshable> refreshables = mapping.get(lifecycle);
        Optional.ofNullable(refreshables)
                .orElseGet(Collections::emptyList)
                .forEach(x -> {
                    try {
                        x.onRefresh(payload);
                    } catch (Throwable throwable) {
                        log.error("{}", throwable);
                    }
                });
    }

    @Override
    public void publish(Object object) {
        if (eventPublisher != null) {
            eventPublisher.publishEvent(object);
        }
    }
}
