/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.integration.test.enums.constant;

import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;

public class Global {
    private static final Logger LOGGER = LoggerFactory.getLogger(Global.class);
    public static final int WAIT_START_TIME_OUT = 200;
    private static Network network;
    private static int containerSize;

    public static synchronized boolean startContainer(GenericContainer container) {
        try {
            ++containerSize;
            if (network == null) {
                LOGGER.info("The first container is created, creating the network.");
                network = Network.newNetwork();
            }
            container.withNetwork(network);
            container.start();
        }
        catch (Throwable ex) {
            LOGGER.error(ex.getMessage(), ex);
            --containerSize;
            container.close();
            Global.releaseNetwork();
            return false;
        }
        return true;
    }

    public static synchronized void closeContainer(GenericContainer container) {
        --containerSize;
        if (null != container) {
            container.close();
            while (container.isRunning()) {
                try {
                    LOGGER.info("The {} container is not closed, etc. 5 ms.", (Object)container.getDockerImageName());
                    TimeUnit.MILLISECONDS.sleep(5L);
                }
                catch (Exception ex) {
                    LOGGER.error(ex.getMessage(), (Throwable)ex);
                }
            }
            Global.releaseNetwork();
        }
    }

    private static void releaseNetwork() {
        if (containerSize <= 0 && network != null) {
            LOGGER.info("The last container is closed, shutting down the network.");
            network.close();
            network = null;
        }
    }

    static {
        containerSize = 0;
    }
}

