package containers;

import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

import java.util.Objects;

/**
 * canal container
 */
public class CanalContainer extends GenericContainer<CanalContainer> {

    private static int CANAL_PORT = 11111;

    private String slaveId  = "12";
    private boolean autoScan = false;
    private String destination = null;
    private String masterAddress = "mysql:3306";
    private String username = "root";
    private String password = "root";
    private String regexFilter = ".*\\.oqsbigentity.*";

    public CanalContainer withSlaveId(String id){
        this.slaveId = id;
        return this;
    }

    public CanalContainer withAutoScan(boolean autoScan){
        this.autoScan = autoScan;
        return this;
    }

    public CanalContainer withDestination(String destination){
        this.destination = destination;
        return this;
    }

    public CanalContainer withMasterAddress(String masterAddress){
        this.masterAddress = masterAddress;
        return this;
    }

    public CanalContainer withDbUserName(String username){
        this.username = username;
        return this;
    }

    public CanalContainer withDbPassword(String password){
        this.password = password;
        return this;
    }

    public CanalContainer withRegexFilter(String regexFilter){
        this.regexFilter = regexFilter;
        return this;
    }

    public CanalContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        addExposedPort(CANAL_PORT);
    }

    @Override
    public void configure(){
        Objects.requireNonNull(destination, "destination cannot be null");
        withEnv("canal.instance.mysql.slaveId", slaveId);
        withEnv("canal.auto.scan", Boolean.toString(autoScan));
        withEnv("canal.destinations", destination);
        withEnv("canal.instance.master.address", masterAddress);
        withEnv("canal.instance.dbUsername", username);
        withEnv("canal.instance.dbPassword", password);
        withEnv("canal.instance.filter.regex", regexFilter);
    }
}
