package containers;

import com.github.dockerjava.api.command.InspectContainerResponse;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

import java.io.IOException;

/**
 * manticroe
 */
public class ManticoreContainer extends GenericContainer<ManticoreContainer> {

    private final static int MANTICORE_PORT = 9306;

    public ManticoreContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        addExposedPort(MANTICORE_PORT);
        withClasspathResourceMapping("manticore.conf", "/manticore.conf", BindMode.READ_ONLY);
        withClasspathResourceMapping("manticore.sql", "/init.sql", BindMode.READ_ONLY);
        withCommand("/usr/bin/searchd", "--nodetach", "--config", "/manticore.conf");
    }

    @Override
    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        super.containerIsStarted(containerInfo);
        try {
            ExecResult execResult = this.execInContainer("mysql",  "-h","0", "-P", "9306", "-e", "source /init.sql");
            System.out.println("Manticore" + execResult);
        } catch (IOException e) {
            e.printStackTrace();
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}
