//package containers;
//
//import org.junit.jupiter.api.extension.ExtensionContext;
//import org.testcontainers.containers.BindMode;
//import org.testcontainers.containers.GenericContainer;
//import org.testcontainers.containers.Network;
//import org.testcontainers.utility.DockerImageName;
//
//
///**
// * oqs dependency on
// * - canal
// * - mysql
// * - bocp
// * - redis
// */
//public class OqsContainer extends GenericContainer<OqsContainer> implements  ExtensionContext.Store.CloseableResource {
//
//    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse("registry-developer.xforcecloud.com/ultraman-xplat-metadata/oqs-engine");
//
//    public static final int OQS_GRPC_PORT = 8081;
//
//    public static final int OQS_WEB_PORT = 8086;
//
//    private static final String DATABASE = "oqsengine";
//
//    private Network network;
//
//    private GenericContainer redisContainer;
//
//    private GenericContainer mysqlContainer;
//
//    private GenericContainer manticoreContainer;
//
//    private GenericContainer canalContainer;
//
//    private String name;
//
//    private String env = "prod";
//
//    private boolean enableChangeLog = false;
//
//    private String destinationStr = "";
//
//    public static final DockerImageName DEFAULT_CANAL_NAME = DockerImageName.parse("registry-developer.xforcecloud.com/ultraman-xplat-metadata/oqs-engine");
//
//    private String mysqlConnectStr = null;
//    private String canalConnectStr = null;
//    private String redisConnectStr = null;
//
//    public OqsContainer(String version) {
//        this(DEFAULT_IMAGE_NAME.withTag(version));
//    }
//
//    public OqsContainer(final DockerImageName dockerImageName) {
//        super(dockerImageName);
//
//        dockerImageName.assertCompatibleWith(DEFAULT_IMAGE_NAME);
//
//        withExposedPorts(OQS_GRPC_PORT, OQS_WEB_PORT);
//
//        network = Network.newNetwork();
//
//        //TODO current use all embedded
//        mysqlContainer = new MySQLContainer(DockerImageName.parse("mysql").withTag("5.7.28"))
//                .withDatabaseName(DATABASE)
//                .withInitScript("init.sql")
//                .withPassword("root")
//                .withUsername("root")
//                .withClasspathResourceMapping("mysql.cnf", "/etc/my.cnf", BindMode.READ_ONLY)
//                .withNetwork(network)
//                .withNetworkAliases("mysql");
//
//        redisContainer = new GenericContainer(DockerImageName.parse("redis").withTag("5.0.12"))
//                .withNetwork(network)
//                .withNetworkAliases("redis");
//
//        manticoreContainer = new ManticoreContainer(DockerImageName
//                .parse("manticoresearch/manticore").withTag("3.5.2"))
//                .withNetwork(network)
//                .withNetworkAliases("manticore");
//
//        canalContainer = new CanalContainer(DockerImageName.parse("canal/canal-server").withTag("v1.1.4"))
//                .withDestination("oqsengine")
//                .withNetwork(network)
//                .withNetworkAliases("canal");
//
//        dependsOn(mysqlContainer, redisContainer, manticoreContainer, canalContainer);
//    }
//
//    public OqsContainer withMysql() {
//        mysqlConnectStr = null;
//        return this;
//    }
//
//    public OqsContainer withEnv(String env){
//        this.env = env;
//        return this;
//    }
//
//    public OqsContainer withName(String name){
//        this.name = name;
//        return this;
//    }
//
//    public OqsContainer withChangelog(boolean enabled){
//        this.enableChangeLog = enabled;
//        return this;
//    }
//
//    @Override
//    public String getContainerName(){
//        return this.name;
//    }
//
//    public OqsContainer withExternalMysql(String jdbcUrl) {
//        mysqlConnectStr = jdbcUrl;
//        return this;
//    }
//
//    public OqsContainer withCanal() {
//        canalConnectStr = null;
//        return this;
//    }
//
//    public OqsContainer withExternalCanal(String canalConnectStr) {
//        this.canalConnectStr = canalConnectStr;
//        return this;
//    }
//
//    public OqsContainer withRedis() {
//        this.redisConnectStr = null;
//        return this;
//    }
//
//    public OqsContainer withExternalRedis(String redisUrl) {
//        this.redisConnectStr = redisUrl;
//        return this;
//    }
//
//    public GenericContainer getRedisContainer() {
//        return redisContainer;
//    }
//
//    public GenericContainer getMysqlContainer() {
//        return mysqlContainer;
//    }
//
//    public GenericContainer getManticoreContainer() {
//        return manticoreContainer;
//    }
//
//    public GenericContainer getCanalContainer() {
//        return canalContainer;
//    }
//
//    @Override
//    public void configure() {
//        withClasspathResourceMapping("oqsengine-ds.conf", "/xplat/oqsengine-ds.conf", BindMode.READ_ONLY);
//        withClasspathResourceMapping("application.yaml", "/xplat/application.yaml", BindMode.READ_ONLY);
//        withNetwork(network);
//        this.getContainerName();
//        this.addEnv("REDIS_URI", "redis://redis:6379");
//        /**
//         * above oqsengine 1.3.1
//         */
//        this.addEnv("REDIS_LETTUCE_URI", "redis://redis:6379");
//        //redisson   singel  address
//        this.addEnv("REDIS_REDISSON_SINGEL_ADDRESS", "redis://redis:6379");
//        if(env.equals("dev")) {
//            this.addEnv("META_GRPC_HOST", "120.55.249.44");
//            this.addEnv("META_GRPC_PORT", "23111");
//        }
//
//        if(enableChangeLog) {
//            this.addEnv("CHANGEDLOG_ENABLED", "true");
//        }
//
//        this.withCreateContainerCmdModifier(x -> {
//            x.withEntrypoint("java", "-jar", "-Dds=/xplat/oqsengine-ds.conf", "/xplat/xplat-meta-oqsengine.jar", "--spring.config.location=/xplat/application.yaml");
//        });
//    }
//
//    @Override
//    public void close() {
//
//        super.close();
//
//        if(network != null) {
//            network.close();
//        }
//
//        if(redisContainer != null && redisContainer.isRunning()){
//            try {
//                redisContainer.close();
//            } catch(Exception ex){
//
//            }
//        }
//
//        if(canalContainer != null && canalContainer.isRunning()) {
//            try{
//                canalContainer.close();
//            } catch (Exception ex){
//
//            }
//        }
//
//        if(mysqlContainer != null && mysqlContainer.isRunning()){
//            try {
//                mysqlContainer.close();
//            } catch(Exception ex){
//
//            }
//        }
//
//        if(manticoreContainer != null && manticoreContainer.isRunning()){
//            try {
//                manticoreContainer.close();
//            } catch(Exception ex){
//
//            }
//        }
//    }
//}
