/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.integration.test.container.impl;

import com.xforceplus.ultraman.oqsengine.plus.integration.test.container.AbstractContainerExtension;
import com.xforceplus.ultraman.oqsengine.plus.integration.test.enums.ContainerSupport;
import com.xforceplus.ultraman.oqsengine.plus.integration.test.utils.SqlInitUtils;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;

public class MysqlContainer
extends AbstractContainerExtension {
    private static final String MYSQL_USER_PASS = "root";
    private static final Logger LOGGER = LoggerFactory.getLogger(MysqlContainer.class);
    private GenericContainer container;

    @Override
    protected GenericContainer buildContainer() {
        this.container = new GenericContainer("mysql:8.0.31").withNetworkAliases(new String[]{MysqlContainer.buildAliase("mysql")}).withExposedPorts(new Integer[]{3306}).withEnv("MYSQL_DATABASE", "oqsengine").withEnv("MYSQL_ROOT_USERNAME", MYSQL_USER_PASS).withEnv("MYSQL_ROOT_PASSWORD", MYSQL_USER_PASS).withClasspathResourceMapping("mysql/mysql.cnf", "/etc/my.cnf", BindMode.READ_ONLY).waitingFor(Wait.forListeningPort().withStartupTimeout(Duration.ofSeconds(200L)));
        return this.container;
    }

    @Override
    protected void init() {
        this.setSystemProperties(this.container.getHost(), this.container.getMappedPort(3306).toString());
        try {
            SqlInitUtils.execute("/mysql", "MYSQL_JDBC_WITH_AUTH");
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    protected void clean() {
        if (this.container != null) {
            try {
                SqlInitUtils.clean("MYSQL_JDBC_WITH_AUTH");
                SqlInitUtils.execute("/mysql/drop", "MYSQL_JDBC_WITH_AUTH");
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    @Override
    protected ContainerSupport containerSupport() {
        return ContainerSupport.MYSQL;
    }

    @Override
    protected GenericContainer getGenericContainer() {
        return this.container;
    }

    private void setSystemProperties(String address, String port) {
        if (null == address || null == port) {
            throw new RuntimeException(String.format("container mysql init failed of null value, address[%s] or port[%s]", address, port));
        }
        System.setProperty("MYSQL_HOST", address);
        System.setProperty("MYSQL_PORT", port);
        System.setProperty("MYSQL_JDBC", String.format("jdbc:mysql://%s:%s/oqsengine?useUnicode=true&serverTimezone=GMT&useSSL=false&characterEncoding=utf8&allowMultiQueries=true&allowPublicKeyRetrieval=true&rewriteBatchedStatements=true&connectTimeout=50000&socketTimeout=30000", address, port));
        System.setProperty("MYSQL_JDBC_WITH_AUTH", String.format("jdbc:mysql://%s:%s/oqsengine?useUnicode=true&serverTimezone=GMT&useSSL=false&characterEncoding=utf8&allowMultiQueries=true&allowPublicKeyRetrieval=true&rewriteBatchedStatements=true&connectTimeout=50000&socketTimeout=30000&user=%s&password=%s", address, port, MYSQL_USER_PASS, MYSQL_USER_PASS));
        LOGGER.info("Start mysql server.({}:{})", (Object)address, (Object)port);
        LOGGER.info("JDBC URL: {}", (Object)System.getProperty("MYSQL_JDBC", "NULL"));
        LOGGER.info("JDBC AUTH URL: {}", (Object)System.getProperty("MYSQL_JDBC_WITH_AUTH", "NULL"));
    }
}

