package com.xforceplus.ultraman.sdk.invocation.invoke.impl;

import com.xforceplus.ultraman.sdk.invocation.invoke.InvocationManager;
import com.xforceplus.ultraman.sdk.invocation.invoke.SQLTimeAware;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.core.SupplierUtils;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.hint.RelHint;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;

/**
 * Fallback(Retry(CircuitBreaker(Supplier))) To a RateLimiter
 *
 */
public class QueryBasedInvocationManager implements InvocationManager<List<Object>>, SQLTimeAware {

    private RetryConfig retryConfig;

    private RateLimiterConfig rateLimiterConfig;

    private CircuitBreaker normalCircuitBreaker;

    private CircuitBreakerConfig circuitBreakerConfig;

    private long slowThreshold ;

    private Map<String, RateLimiter> slowRateLimiter = new ConcurrentHashMap<>();

    @Override
    public void record(String token, List<RelHint> hints, long executionTime) {
        if(executionTime > slowThreshold) {
            slowRateLimiter.compute(token, (k,v) -> {
               if(v == null) {
                   v = RateLimiter.of(token, rateLimiterConfig);
               }
               return v;
            });
        }
    }

    /**
     * TODO
     */
    public QueryBasedInvocationManager(long slowThreshold) {
        circuitBreakerConfig = CircuitBreakerConfig.ofDefaults();
        rateLimiterConfig = RateLimiterConfig.ofDefaults();
        retryConfig = RetryConfig.ofDefaults();
        normalCircuitBreaker = CircuitBreaker.of("normal", circuitBreakerConfig);
        this.slowThreshold = slowThreshold;

        normalCircuitBreaker.getEventPublisher().onEvent(x -> {
            System.out.println(x);
        });
    }

    /**
     * TODO get token from input
     * @param code
     * @param rawTree
     * @param relHintList
     * @return
     */
    @Override
    public String getToken(String code, RelNode rawTree, List<RelHint> relHintList, Map<String, Object> context) {
        return code;
    }

    @Override
    public List<Object> invoke(String token, Function<InvocationType, List<Object>> supplier) {
        RateLimiter rateLimiter = slowRateLimiter.get(token);
        Retry retry = Retry.of(token, retryConfig);
        Supplier<List<Object>> decorateSupplier = Retry.decorateSupplier(retry, normalCircuitBreaker.decorateSupplier(() -> supplier.apply(InvocationType.NORMAL)));

        if(rateLimiter != null) {
            decorateSupplier = RateLimiter.decorateSupplier(rateLimiter, decorateSupplier);
        }
        Supplier<List<Object>> recover = SupplierUtils.recover(decorateSupplier, throwable -> {
            Supplier<List<Object>> fallbackSupplier = () -> supplier.apply(InvocationType.FALLBACK);

            if(rateLimiter != null) {
                fallbackSupplier = RateLimiter.decorateSupplier(rateLimiter, fallbackSupplier);
            }
            return fallbackSupplier.get();
        });

        return recover.get();
    }
}
