/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.sdk.invocation.invoke.impl;

import com.xforceplus.ultraman.sdk.invocation.invoke.InvocationManager;
import com.xforceplus.ultraman.sdk.invocation.invoke.SQLTimeAware;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.core.SupplierUtils;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.hint.RelHint;

public class QueryBasedInvocationManager
implements InvocationManager<List<Object>>,
SQLTimeAware {
    private RetryConfig retryConfig;
    private RateLimiterConfig rateLimiterConfig;
    private CircuitBreaker normalCircuitBreaker;
    private CircuitBreakerConfig circuitBreakerConfig;
    private long slowThreshold;
    private Map<String, RateLimiter> slowRateLimiter = new ConcurrentHashMap<String, RateLimiter>();

    @Override
    public void record(String token, List<RelHint> hints, long executionTime) {
        if (executionTime > this.slowThreshold) {
            this.slowRateLimiter.compute(token, (k, v) -> {
                if (v == null) {
                    v = RateLimiter.of((String)token, (RateLimiterConfig)this.rateLimiterConfig);
                }
                return v;
            });
        }
    }

    public QueryBasedInvocationManager(long slowThreshold) {
        this.circuitBreakerConfig = CircuitBreakerConfig.ofDefaults();
        this.rateLimiterConfig = RateLimiterConfig.ofDefaults();
        this.retryConfig = RetryConfig.ofDefaults();
        this.normalCircuitBreaker = CircuitBreaker.of((String)"normal", (CircuitBreakerConfig)this.circuitBreakerConfig);
        this.slowThreshold = slowThreshold;
        this.normalCircuitBreaker.getEventPublisher().onEvent(x -> System.out.println(x));
    }

    @Override
    public String getToken(String code, RelNode rawTree, List<RelHint> relHintList, Map<String, Object> context) {
        return code;
    }

    @Override
    public List<Object> invoke(String token, Function<InvocationManager.InvocationType, List<Object>> supplier) {
        RateLimiter rateLimiter = this.slowRateLimiter.get(token);
        Retry retry = Retry.of((String)token, (RetryConfig)this.retryConfig);
        Supplier decorateSupplier = Retry.decorateSupplier((Retry)retry, (Supplier)this.normalCircuitBreaker.decorateSupplier(() -> (List)supplier.apply(InvocationManager.InvocationType.NORMAL)));
        if (rateLimiter != null) {
            decorateSupplier = RateLimiter.decorateSupplier((RateLimiter)rateLimiter, (Supplier)decorateSupplier);
        }
        Supplier recover = SupplierUtils.recover((Supplier)decorateSupplier, throwable -> {
            Supplier fallbackSupplier = () -> (List)supplier.apply(InvocationManager.InvocationType.FALLBACK);
            if (rateLimiter != null) {
                fallbackSupplier = RateLimiter.decorateSupplier((RateLimiter)rateLimiter, fallbackSupplier);
            }
            return fallbackSupplier.get();
        });
        return (List)recover.get();
    }
}

