/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.sdk.invocation.invoke.impl;

import com.xforceplus.ultraman.sdk.invocation.invoke.InvocationManager;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.hint.RelHint;

public class SchemaBasedInvocationManager
implements InvocationManager<List<Object>> {
    final Map<String, RateLimiter> keyRateLimiters = new ConcurrentHashMap<String, RateLimiter>();
    final Map<String, CircuitBreaker> keyCircuitBreakers = new ConcurrentHashMap<String, CircuitBreaker>();
    final CircuitBreakerConfig config;
    final boolean useCircuitBreaker;

    public SchemaBasedInvocationManager(Map<String, Integer> mapping, Boolean useCircuitBreaker) {
        mapping.forEach((k, v) -> {
            if (v != null) {
                RateLimiterConfig config = RateLimiterConfig.custom().limitRefreshPeriod(Duration.ofSeconds(1L)).limitForPeriod(v.intValue()).timeoutDuration(Duration.ofSeconds(5L)).build();
                RateLimiter rateLimiter = RateLimiter.of((String)k, (RateLimiterConfig)config);
                this.keyRateLimiters.put((String)k, rateLimiter);
            }
        });
        this.config = CircuitBreakerConfig.custom().failureRateThreshold(50.0f).waitDurationInOpenState(Duration.ofMillis(3000L)).permittedNumberOfCallsInHalfOpenState(10).recordExceptions(new Class[]{Throwable.class}).build();
        this.useCircuitBreaker = useCircuitBreaker;
    }

    @Override
    public String getToken(String code, RelNode rawTree, List<RelHint> list, Map<String, Object> context) {
        return null;
    }

    @Override
    public List<Object> invoke(String token, Function<InvocationManager.InvocationType, List<Object>> supplier) {
        return null;
    }
}

