package com.xforceplus.ultraman.metadata.sync.grpc;

import io.reactivex.Observable;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Slf4j
public abstract class OfflineSupport<T> {

    private boolean isOffline;

    public OfflineSupport(boolean isOffline) {
        this.isOffline = isOffline;
    }

    public Observable<T> getSource(){
        if(isOffline) {
            log.warn("is in Offline mode");
            return Observable.empty();
        } else {
            return getOnlineSource();
        }
    }

    public abstract Observable<T> getOnlineSource();
}
