package com.xforceplus.ultraman.metadata.sync.grpc;

import akka.stream.ActorMaterializer;
import akka.stream.javadsl.AsPublisher;
import akka.stream.javadsl.Sink;
import com.xforceplus.ultraman.config.ConfigurationEngine;
import com.xforceplus.ultraman.config.json.JsonConfigNode;
import com.xforceplus.ultraman.metadata.grpc.Base;
import com.xforceplus.ultraman.metadata.grpc.DictCheckServiceClient;
import com.xforceplus.ultraman.metadata.grpc.DictUpResult;
import com.xforceplus.ultraman.sdk.infra.base.AppIdResolver;
import com.xforceplus.ultraman.sdk.infra.base.AuthConfig;
import com.xforceplus.xplat.galaxy.grpc.client.LongConnect;
import io.reactivex.Observable;
import io.vavr.Tuple2;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * TODO update
 */
public class DictInitService extends OfflineSupport<DictUpResult> implements InitializingBean {

    @Autowired
    private DictCheckServiceClient client;

    @Autowired
    private ActorMaterializer mat;

    private AuthConfig authConfig;

    private Logger logger = LoggerFactory.getLogger(DictInitService.class);

    @Autowired
    private ConfigurationEngine<DictUpResult, JsonConfigNode> dictConfigEngine;

    public DictInitService(
            AuthConfig authConfig
            , boolean isOffline
    ) {
        super(isOffline);
        this.authConfig = authConfig;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Observable<DictUpResult> dictUpSource = getSource();
        dictConfigEngine.registerSource(dictUpSource);
    }

    @Override
    public Observable<DictUpResult> getOnlineSource() {
        String appIds = authConfig.getAppId();

        List<Tuple2<String, String>> appAndEnvTuple = AppIdResolver
                .getAppAndEnvTuple(appIds, authConfig.getEnv());

        return appAndEnvTuple.stream().map(x -> {
            Base.Authorization request = Base.Authorization.newBuilder()
                    .setAppId(x._1())
                    .setTenantId(authConfig.getTenant())
                    .setEnv(x._2())
                    .build();

            Publisher<DictUpResult> dictPublisher = LongConnect.safeSource(2, 20
                    , () -> client.checkStreaming(request))
                    .log("DictService")
                    .runWith(Sink.asPublisher(AsPublisher.WITH_FANOUT), mat);

            return Observable.fromPublisher(dictPublisher);
        }).reduce(Observable::mergeWith)
                .orElseGet(() -> {
                    logger.warn("Empty Dict Source");
                    return Observable.empty();
                });
    }
}
