/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.sync.grpc;

import akka.japi.function.Creator;
import akka.japi.function.Function;
import akka.stream.ActorMaterializer;
import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.javadsl.AsPublisher;
import akka.stream.javadsl.Sink;
import com.xforceplus.ultraman.config.ConfigurationEngine;
import com.xforceplus.ultraman.config.json.JsonConfigNode;
import com.xforceplus.ultraman.metadata.grpc.Base;
import com.xforceplus.ultraman.metadata.grpc.CheckServiceClient;
import com.xforceplus.ultraman.metadata.grpc.ModuleUpResult;
import com.xforceplus.ultraman.metadata.sync.grpc.OfflineSupport;
import com.xforceplus.ultraman.sdk.infra.base.AppIdResolver;
import com.xforceplus.ultraman.sdk.infra.base.AuthConfig;
import com.xforceplus.xplat.galaxy.grpc.client.LongConnect;
import io.reactivex.Observable;
import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;

public class ModuleInitService
extends OfflineSupport<List<ModuleUpResult>>
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ModuleInitService.class);
    private Logger logger = LoggerFactory.getLogger(ModuleInitService.class);
    private final CheckServiceClient checkServiceClient;
    private final ActorMaterializer mat;
    private AuthConfig authConfig;
    private final ApplicationEventPublisher publisher;
    @Value(value="${xplat.oqsengine.sdk.init-size:5}")
    private Integer size;
    @Value(value="${xplat.oqsengine.sdk.init-time:10}")
    private Integer time;
    @Autowired
    private ConfigurationEngine<ModuleUpResult, JsonConfigNode> moduleConfigEngine;

    public ModuleInitService(CheckServiceClient checkServiceClient, ActorMaterializer mat, AuthConfig authConfig, ApplicationEventPublisher publisher, boolean isOffline) {
        super(isOffline);
        this.checkServiceClient = checkServiceClient;
        this.mat = mat;
        this.authConfig = authConfig;
        this.publisher = publisher;
    }

    public void afterPropertiesSet() throws Exception {
        Observable moduleResult = this.getSource();
        this.moduleConfigEngine.registerSource(moduleResult.concatMap(Observable::fromIterable));
    }

    @Override
    public Observable<List<ModuleUpResult>> getOnlineSource() {
        String appIds = this.authConfig.getAppId();
        List appAndEnvTuple = AppIdResolver.getAppAndEnvTuple((String)appIds, (String)this.authConfig.getEnv());
        return appAndEnvTuple.stream().map(x -> {
            Base.Authorization request = Base.Authorization.newBuilder().setAppId((String)x._1()).setEnv((String)x._2()).setTenantId(this.authConfig.getTenant()).build();
            return request;
        }).map(req -> {
            Publisher moduleService = (Publisher)LongConnect.safeSource((int)2, (int)20, (Creator & Serializable)() -> this.checkServiceClient.checkStreaming(req)).log("ModuleService").groupedWithin(this.size.intValue(), Duration.ofSeconds(this.time.intValue())).map((Function & Serializable)x -> {
                this.logger.info("Got module size {}", (Object)x.size());
                return x;
            }).runWith((Graph)Sink.asPublisher((AsPublisher)AsPublisher.WITH_FANOUT), (Materializer)this.mat);
            return Observable.fromPublisher((Publisher)moduleService);
        }).reduce(Observable::mergeWith).orElseGet(() -> {
            this.logger.warn("Empty Bo Source");
            return Observable.empty();
        });
    }
}

