/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.sync.grpc.listener;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import com.xforceplus.ultraman.config.ConfigNode;
import com.xforceplus.ultraman.metadata.grpc.Base;
import com.xforceplus.ultraman.metadata.grpc.DictUpResult;
import com.xforceplus.ultraman.metadata.grpc.ModuleUpResult;
import com.xforceplus.ultraman.metadata.repository.MetadataRepository;
import com.xforceplus.ultraman.metadata.sync.grpc.event.ConfigChangeEvent;
import com.xforceplus.ultraman.metadata.sync.grpc.event.MetadataModuleGotEvent;
import com.xforceplus.ultraman.metadata.sync.grpc.store.DictMapLocalStore;
import com.xforceplus.ultraman.sdk.infra.base.AuthConfig;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;

public class ConfigListener {
    private static final Logger log = LoggerFactory.getLogger(ConfigListener.class);
    @Autowired
    private DictMapLocalStore dictMapLocalStore;
    @Autowired
    private MetadataRepository repository;
    private AuthConfig authconfig;
    @Autowired
    private ObjectMapper mapper;

    public ConfigListener(AuthConfig authconfig) {
        this.authconfig = authconfig;
    }

    @EventListener(condition="#event.type.equals('BO')")
    public MetadataModuleGotEvent boChangeListener(ConfigChangeEvent event) {
        log.info("UPDATE BO");
        ConfigNode confignode = event.getChangeList().getCurrent();
        JsonNode jsonNode = (JsonNode)confignode.getOrigin();
        ModuleUpResult.Builder moduleBuilder = ModuleUpResult.newBuilder();
        try {
            JsonFormat.parser().merge(jsonNode.toString(), (Message.Builder)moduleBuilder);
        }
        catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
        }
        ModuleUpResult moduleUpResult = moduleBuilder.build();
        return new MetadataModuleGotEvent(Base.Authorization.newBuilder().setAppId(moduleUpResult.getAppIds(0)).setTenantId(this.authconfig.getTenant()).build(), Collections.singletonList(moduleUpResult));
    }

    @EventListener(condition="#event.type.equals('DICT')")
    public void dictChangeListener(ConfigChangeEvent event) {
        log.info("UPDATE DICT");
        ConfigNode confignode = event.getChangeList().getCurrent();
        JsonNode jsonNode = (JsonNode)confignode.getOrigin();
        DictUpResult.Builder dictBuilder = DictUpResult.newBuilder();
        try {
            JsonFormat.parser().merge(jsonNode.toString(), (Message.Builder)dictBuilder);
        }
        catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
        }
        DictUpResult result = dictBuilder.build();
        this.dictMapLocalStore.save(result, result.getAuthorization(0).getAppId());
        if (log.isInfoEnabled()) {
            result.getDictsList().forEach(dict -> log.info("Dict {}:{}:{} saved", new Object[]{dict.getCode(), dict.getPublishDictId(), dict.getId()}));
        }
    }
}

