/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.sync.grpc.service.impl;

import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.metadata.domain.vo.dto.DictItem;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ResponseList;
import com.xforceplus.ultraman.metadata.service.DictService;
import com.xforceplus.ultraman.metadata.sync.grpc.store.DictMapLocalStore;
import com.xforceplus.ultraman.metadata.sync.grpc.store.utils.RowUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.query.builder.SatisfiedWhereBuilder;

public class DictServiceImpl
implements DictService {
    private final ContextService contextService;
    private final DictMapLocalStore dictMapLocalStore;

    public DictServiceImpl(ContextService contextService, DictMapLocalStore dictMapLocalStore) {
        this.dictMapLocalStore = dictMapLocalStore;
        this.contextService = contextService;
    }

    public List<DictItem> findDictItems(String enumId, String enumCode, String tenantCode) {
        String dictCode;
        DataSet ds = null;
        List rows = new ArrayList();
        if (StringUtils.isEmpty((CharSequence)enumCode)) {
            if (!StringUtils.isEmpty((CharSequence)tenantCode) && (rows = (ds = ((SatisfiedWhereBuilder)this.dictMapLocalStore.query().selectAll().where("publishDictId").eq(enumId)).execute()).toRows()).size() > 0) {
                dictCode = RowUtils.getRowValue((Row)rows.get(0), "dictCode").map(Object::toString).orElse("");
                ds = ((SatisfiedWhereBuilder)((SatisfiedWhereBuilder)this.dictMapLocalStore.query().selectAll().where("dictCode").eq(dictCode)).and("tenantCode").eq(tenantCode)).execute();
            }
            if (ds != null) {
                rows = ds.toRows();
            }
            if (rows == null || rows.size() <= 0) {
                ds = ((SatisfiedWhereBuilder)this.dictMapLocalStore.query().selectAll().where("publishDictId").eq(enumId)).execute();
                rows = ds.toRows();
            }
        } else {
            if (!StringUtils.isEmpty((CharSequence)tenantCode) && !StringUtils.isEmpty((CharSequence)tenantCode) && (rows = (ds = ((SatisfiedWhereBuilder)this.dictMapLocalStore.query().selectAll().where("publishDictId").eq(enumId)).execute()).toRows()).size() > 0) {
                dictCode = RowUtils.getRowValue((Row)rows.get(0), "dictCode").map(Object::toString).orElse("");
                ds = ((SatisfiedWhereBuilder)((SatisfiedWhereBuilder)((SatisfiedWhereBuilder)this.dictMapLocalStore.query().selectAll().where("dictCode").eq(dictCode)).and("tenantCode").eq(tenantCode)).and("code").eq(enumCode)).execute();
            }
            if (ds != null) {
                rows = ds.toRows();
            }
            if (rows == null || rows.size() <= 0) {
                ds = ((SatisfiedWhereBuilder)((SatisfiedWhereBuilder)this.dictMapLocalStore.query().selectAll().where("publishDictId").eq(enumId)).and("code").eq(enumCode)).execute();
                rows = ds.toRows();
            }
        }
        List items = (List)rows.stream().map(this::toDictItem).collect(Collectors.toCollection(ResponseList::new));
        return this.getMaxVersionList(items);
    }

    private List<DictItem> getMaxVersionList(List<DictItem> dictItems) {
        ResponseList dictItemList = new ResponseList();
        if (dictItems.size() > 0) {
            String maxVersion = dictItems.get(0).getVersion();
            for (int i = 0; i < dictItems.size(); ++i) {
                if (this.compare(maxVersion, dictItems.get(i).getVersion()) < 0) {
                    dictItemList.clear();
                    dictItemList.add(dictItems.get(i));
                    maxVersion = dictItems.get(i).getVersion();
                    continue;
                }
                if (!maxVersion.equals(dictItems.get(i).getVersion())) continue;
                dictItemList.add(dictItems.get(i));
            }
        }
        return dictItemList;
    }

    private DictItem toDictItem(Row row) {
        DictItem dictItem = new DictItem();
        dictItem.setText(RowUtils.getRowValue(row, "name").map(Object::toString).orElse(""));
        dictItem.setValue(RowUtils.getRowValue(row, "code").map(Object::toString).orElse(""));
        dictItem.setIcon(RowUtils.getRowValue(row, "icon").map(Object::toString).orElse(""));
        dictItem.setVersion(RowUtils.getRowValue(row, "version").map(Object::toString).orElse(""));
        dictItem.setDictId(RowUtils.getRowValue(row, "publishDictId").map(Object::toString).orElse(""));
        dictItem.setDictCode(RowUtils.getRowValue(row, "dictCode").map(Object::toString).orElse(""));
        dictItem.setDictName(RowUtils.getRowValue(row, "dictName").map(Object::toString).orElse(""));
        return dictItem;
    }

    public int compare(String v1, String v2) {
        if (StringUtils.isEmpty((CharSequence)v1) && StringUtils.isEmpty((CharSequence)v2)) {
            return 0;
        }
        if (StringUtils.isEmpty((CharSequence)v1)) {
            return -1;
        }
        if (StringUtils.isEmpty((CharSequence)v2)) {
            return 1;
        }
        int[] varr1 = this.getVersionArray(v1);
        int[] varr2 = this.getVersionArray(v2);
        int lim = Math.min(varr1.length, varr2.length);
        for (int k = 0; k < lim; ++k) {
            if (varr1[k] == varr2[k]) {
                continue;
            }
            return varr1[k] > varr2[k] ? 1 : -1;
        }
        if (varr1.length == varr2.length) {
            return 0;
        }
        return varr1.length > varr2.length ? 1 : -1;
    }

    public int[] getVersionArray(String v) {
        String[] sarray = StringUtils.split((String)v, (String)".");
        int[] varray = new int[sarray.length];
        for (int k = 0; k < sarray.length; ++k) {
            varray[k] = Integer.parseInt(sarray[k]);
        }
        return varray;
    }

    public List<DictItem> findDictItemsByCode(String code, String enumCode, String tenantCode) {
        DataSet ds = null;
        List rows = new ArrayList();
        if (StringUtils.isEmpty((CharSequence)enumCode)) {
            if (!StringUtils.isEmpty((CharSequence)tenantCode)) {
                ds = ((SatisfiedWhereBuilder)((SatisfiedWhereBuilder)this.dictMapLocalStore.query().selectAll().where("dictCode").eq(code)).and("tenantCode").eq(tenantCode)).execute();
            }
            if (ds != null) {
                rows = ds.toRows();
            }
            if (rows == null || rows.size() <= 0) {
                ds = ((SatisfiedWhereBuilder)this.dictMapLocalStore.query().selectAll().where("dictCode").eq(code)).execute();
                rows = ds.toRows();
            }
        } else {
            if (!StringUtils.isEmpty((CharSequence)tenantCode)) {
                ds = ((SatisfiedWhereBuilder)((SatisfiedWhereBuilder)((SatisfiedWhereBuilder)this.dictMapLocalStore.query().selectAll().where("dictCode").eq(code)).and("tenantCode").eq(tenantCode)).and("code").eq(enumCode)).execute();
            }
            if (ds != null) {
                rows = ds.toRows();
            }
            if (rows == null || rows.size() <= 0) {
                ds = ((SatisfiedWhereBuilder)((SatisfiedWhereBuilder)this.dictMapLocalStore.query().selectAll().where("dictCode").eq(code)).and("code").eq(enumCode)).execute();
                rows = ds.toRows();
            }
        }
        List items = (List)rows.stream().map(this::toDictItem).collect(Collectors.toCollection(ResponseList::new));
        return this.getMaxVersionList(items);
    }

    public List<DictItem> findAllDictItems(String tenantCode) {
        String dictCode;
        DataSet ds = null;
        List rows = new ArrayList();
        if (!StringUtils.isEmpty((CharSequence)tenantCode)) {
            if (!StringUtils.isEmpty((CharSequence)tenantCode) && (rows = (ds = this.dictMapLocalStore.query().selectAll().execute()).toRows()).size() > 0) {
                dictCode = RowUtils.getRowValue((Row)rows.get(0), "dictCode").map(Object::toString).orElse("");
                ds = ((SatisfiedWhereBuilder)((SatisfiedWhereBuilder)this.dictMapLocalStore.query().selectAll().where("dictCode").eq(dictCode)).and("tenantCode").eq(tenantCode)).execute();
            }
        } else {
            ds = this.dictMapLocalStore.query().selectAll().execute();
            rows = ds.toRows();
            if (rows.size() > 0) {
                dictCode = RowUtils.getRowValue((Row)rows.get(0), "dictCode").map(Object::toString).orElse("");
                ds = ((SatisfiedWhereBuilder)this.dictMapLocalStore.query().selectAll().where("dictCode").eq(dictCode)).execute();
            }
        }
        List items = (List)rows.stream().map(this::toDictItem).collect(Collectors.toCollection(ResponseList::new));
        return this.getMaxVersionList(items);
    }

    public List<DictItem> findAllDictItems() {
        String tenantCode = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTCODE_KEY);
        return this.findAllDictItems(tenantCode);
    }

    public List<DictItem> findDictItems(String enumId, String enumCode) {
        String tenantCode = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTCODE_KEY);
        return this.findDictItems(enumId, enumCode, tenantCode);
    }

    public List<DictItem> findDictItems(String enumId, String enumCode, Map<String, Object> context) {
        String tenantCode = Optional.ofNullable(context.get(ContextKeys.StringKeys.TENANTCODE_KEY.name())).map(x -> x.toString()).orElse(null);
        return this.findDictItems(enumId, enumCode, tenantCode);
    }

    public List<DictItem> findDictItemsByCode(String code, String enumCode) {
        String tenantCode = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTCODE_KEY);
        return this.findDictItemsByCode(code, enumCode, tenantCode);
    }
}

