/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.sync.grpc.utils;

import com.xforceplus.metadata.schema.rels.MetadataRelationType;
import com.xforceplus.metadata.schema.typed.AppNode;
import com.xforceplus.metadata.schema.typed.BoField;
import com.xforceplus.metadata.schema.typed.BoNode;
import com.xforceplus.metadata.schema.typed.BoRelationship;
import com.xforceplus.metadata.schema.typed.FieldType;
import com.xforceplus.ultraman.metadata.grpc.AppUp;
import com.xforceplus.ultraman.metadata.grpc.BoUp;
import com.xforceplus.ultraman.metadata.grpc.Field;
import com.xforceplus.ultraman.metadata.grpc.ModuleUpResult;
import com.xforceplus.ultraman.metadata.grpc.Relation;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class DomainConverter {
    public static AppNode toAppNode(ModuleUpResult moduleUpResult) {
        AppUp appUp = moduleUpResult.getAppUp();
        List boUpsList = moduleUpResult.getBoUpsList();
        AppNode appNode = new AppNode();
        appNode.setCode(appUp.getCode());
        appNode.setBranchCode(appUp.getBranch());
        appNode.setVersion(appUp.getVersion());
        appNode.setId(Long.toString(appUp.getId()));
        appNode.setName(appUp.getName());
        List boList = boUpsList.stream().map(x -> DomainConverter.toBoNode(x)).collect(Collectors.toList());
        appNode.setBoNodes(boList);
        return appNode;
    }

    public static BoNode toBoNode(BoUp boUp) {
        BoNode boNode = new BoNode();
        boNode.setCode(boUp.getCode());
        boNode.setId(boUp.getId());
        boNode.setName(boUp.getName());
        boNode.setParentId(boUp.getParentBoId());
        boNode.setBoType(boUp.getBoType());
        List fields = boUp.getFieldsList().stream().map(DomainConverter::toBoField).collect(Collectors.toList());
        boNode.setFields(fields);
        List relations = boUp.getRelationsList().stream().map(rel -> DomainConverter.toBoRelation(rel)).collect(Collectors.toList());
        boNode.setRelationships(relations);
        return boNode;
    }

    public static BoRelationship toBoRelation(Relation rel) {
        BoRelationship boRelationship = new BoRelationship();
        if ("OneToMany".equals(rel.getRelationType())) {
            boRelationship.setRelationType(MetadataRelationType.TO_MANY.name());
        } else if ("ManyToOne".equals(rel.getRelationType())) {
            boRelationship.setRelationType(MetadataRelationType.TO_ONE.name());
        }
        boRelationship.setId(rel.getId());
        boRelationship.setRelationCode(rel.getRelName());
        boRelationship.setRelationName(rel.getRelName());
        boRelationship.setBoId(rel.getBoId());
        boRelationship.setJoinBoId(rel.getJoinBoId());
        boRelationship.setBoFieldId((String)Optional.of(rel.getBoField()).map(x -> Long.toString(x)).orElse(null));
        boRelationship.setJoinBoFieldId((String)Optional.of(rel.getJoinField()).map(x -> Long.toString(x)).orElse(null));
        return boRelationship;
    }

    public static BoField toBoField(Field fieldUp) {
        BoField boField = new BoField();
        boField.setName(fieldUp.getName());
        boField.setCode(fieldUp.getCode());
        boField.setId(fieldUp.getId());
        FieldType fieldType = new FieldType();
        fieldType.setValueType(fieldUp.getFieldType());
        fieldType.setDictId(fieldUp.getDictId());
        boField.setFieldType(fieldType);
        return boField;
    }
}

