package com.xforceplus.ultraman.metadata.sync.grpc.autoconfigure;

import akka.actor.ActorSystem;
import akka.stream.ActorMaterializer;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.metadata.grpc.CheckServiceClient;
import com.xforceplus.ultraman.metadata.service.DictService;
import com.xforceplus.ultraman.metadata.sync.grpc.DictInitService;
import com.xforceplus.ultraman.metadata.sync.grpc.ModuleInitService;
import com.xforceplus.ultraman.metadata.sync.grpc.NodeReporterInitService;
import com.xforceplus.ultraman.metadata.component.GlobalInited;
import com.xforceplus.ultraman.metadata.sync.grpc.service.impl.DictServiceImpl;
import com.xforceplus.ultraman.metadata.sync.grpc.store.DictMapLocalStore;
import com.xforceplus.ultraman.sdk.infra.base.AuthConfig;
import com.xforceplus.ultraman.sdk.infra.base.ExecutionConfig;
import com.xforceplus.xplat.galaxy.grpc.spring.EnableGrpcServiceClients;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;

/**
 * bocp grpc
 */
@EnableGrpcServiceClients(basePackages = {"com.xforceplus.ultraman.metadata.grpc", "com.xforceplus.ultraman.oqsengine.sdk"})
@ConditionalOnProperty(value = "xplat.oqsengine.sdk.enabled", matchIfMissing = true)
public class BocpGrpcAutoConfiguration {

    /**
     * default system
     *
     * @return
     */
    @Bean(destroyMethod = "terminate")
    @ConditionalOnMissingBean(ActorSystem.class)
    public ActorSystem actorSystem() {
        return ActorSystem.create();
    }

    /**
     * default mat
     *
     * @param system
     * @return
     */
    @Bean
    @ConditionalOnMissingBean(ActorMaterializer.class)
    public ActorMaterializer mat(ActorSystem system) {
        return ActorMaterializer.create(system);
    }

    @ConditionalOnProperty(value = "xplat.oqsengine.sdk.meta.enabled", matchIfMissing = true)
    @Bean
    public ModuleInitService moduleInitService(
            CheckServiceClient checkServiceClient
            , ActorMaterializer mat, AuthConfig authConfig
            , ApplicationEventPublisher publisher
            , @Value("${xplat.oqsengine.sdk.meta.offline.enabled:false}") boolean isOffline) {
        return new ModuleInitService(checkServiceClient, mat, authConfig, publisher, isOffline);
    }

    @ConditionalOnProperty(value = "xplat.oqsengine.sdk.meta.node.enabled", matchIfMissing = true)
    @Bean
    public NodeReporterInitService nodeReporterInitService(AuthConfig authConfig) {
        return new NodeReporterInitService(authConfig);
    }

    @ConditionalOnProperty(value = "xplat.oqsengine.sdk.meta.enabled", matchIfMissing = true)
    @Bean
    public DictInitService dictInitService(AuthConfig authConfig, @Value("${xplat.oqsengine.sdk.meta.offline.enabled:false}") boolean isOffline) {
        return new DictInitService(authConfig, isOffline);
    }

    @Bean
    public DictMapLocalStore dictMapLocalStore() {
        return DictMapLocalStore.create();
    }

    @Bean
    public DictService dictService(ContextService contextService, DictMapLocalStore dictMapLocalStore){
        return new DictServiceImpl(contextService, dictMapLocalStore);
    }
}
