package com.xforceplus.ultraman.metadata.sync.grpc.listener;

import com.xforceplus.metadata.schema.runtime.MetadataEngine;
import com.xforceplus.metadata.schema.typed.AppNode;
import com.xforceplus.ultraman.metadata.component.GlobalInited;
import com.xforceplus.ultraman.metadata.grpc.ModuleUpResult;
import com.xforceplus.ultraman.metadata.sync.grpc.event.MetadataModuleGotEvent;
import com.xforceplus.ultraman.metadata.sync.grpc.event.MetadataModulePrepareResultEvent;
import com.xforceplus.ultraman.metadata.sync.grpc.event.MetadataModulePreparedErrorEvent;
import com.xforceplus.ultraman.metadata.sync.grpc.event.MetadataModulePreparedEvent;
import com.xforceplus.ultraman.metadata.sync.grpc.utils.DomainConverter;
import com.xforceplus.ultraman.sdk.infra.base.AuthConfig;
import com.xforceplus.ultraman.sdk.infra.base.ExecutionConfig;
import com.xforceplus.ultraman.sdk.infra.event.EventEngine;
import com.xforceplus.ultraman.sdk.infra.event.UltramanLifecycle;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.concurrent.CompletableToListenableFutureAdapter;
import org.springframework.util.concurrent.ListenableFuture;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

/**
 * module event listener
 */
@Slf4j
public class ModuleEventListener {

    @Autowired
    private MetadataEngine metadataEngine;

    @Autowired
    public ApplicationEventPublisher publisher;

    @Autowired
    private EventEngine engine;

    @Autowired
    public GlobalInited globalInited;

    private ExecutionConfig executionConfig;

    private AuthConfig authConfig;

    public ModuleEventListener(ExecutionConfig config, AuthConfig authConfig) {
        this.executionConfig = config;
        this.authConfig = authConfig;
    }

    private List<MetadataModulePrepareResultEvent> skipPrepare(MetadataModuleGotEvent event){
        List<ModuleUpResult> response = event.getResponse();
        return response.stream().map(x -> {

            return new MetadataModulePreparedEvent(
                              x
                            , event.getRequest().getTenantId()
                            , event.getRequest().getAppId());
        }).collect(Collectors.toList());
    }

    //@Async
    @Order
    @EventListener(MetadataModuleGotEvent.class)
    public ListenableFuture<List<MetadataModulePrepareResultEvent>> saveMetadata(MetadataModuleGotEvent event) {
        return new CompletableToListenableFutureAdapter<>(CompletableFuture.completedFuture(skipPrepare(event)));
    }

    @EventListener(MetadataModulePreparedEvent.class)
    public void cleanUpdateAndSave(MetadataModulePreparedEvent preparedEvent) {
        MetadataModulePreparedEvent preparedEventType = (MetadataModulePreparedEvent) preparedEvent;
        ModuleUpResult module = preparedEventType.getModuleUpResult();
        AppNode appNode = DomainConverter.toAppNode(module);
        metadataEngine.save(appNode);
        globalInited.moduleSaved();
        engine.trigger(UltramanLifecycle.METADATA_REFRESHED, appNode);
    }

    @Async
    @EventListener(MetadataModulePreparedErrorEvent.class)
    public void recordFailed(MetadataModulePreparedErrorEvent errorEvent) {
        MetadataModulePreparedErrorEvent errorEventType = (MetadataModulePreparedErrorEvent) errorEvent;
        //TODO log
    }
}
