package com.xforceplus.ultraman.metadata.sync.grpc.store.impl.tables;

import com.xforceplus.ultraman.metadata.sync.grpc.store.TableLike;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * SimpleTableDef boTableDef = new SimpleTableDef("bos", new String[]{"id", "code", "parentId", "name"});
 *         TableDataProvider boTableDataProvider = new MapTableDataProvider(boTableDef, boStore);
 */
public class BoTable implements TableLike {

    public static final String TABLE_NAME = "bos";

    public static final String ID = "id";

    public static final String CODE = "code";

    public static final String VERSION = "version";

    public static final String PARENT_ID = "parentId";

    public static final String NAME = "name";

    public static final String MODULE_ID = "moduleId";

    public static final String ROOT_FLAG = "rootFlag";

    public static final String SYS_TYPE = "sysType";

    public static final String DOMAIN_CODE = "domainCode";

    public static final String DOMAIN_NAME = "domainName";

    public static final String DOMAIN_ROOT_ID = "domainRootId";

    /**
     * type - 0 or null --> normal
     * type - 1 --> external
     */
    public static final String TYPE = "type";

    /**
     * app id
     */
    public static final String APP_ID = "appId";

    private List<Map<String, ?>> store = new ArrayList<>();

    public static final String[] COLUMNS = new String[]{ID, CODE, VERSION, NAME, PARENT_ID, MODULE_ID
            , ROOT_FLAG, SYS_TYPE, DOMAIN_CODE, DOMAIN_NAME, DOMAIN_ROOT_ID, APP_ID, TYPE};

    @Override
    public String name() {
        return TABLE_NAME;
    }

    @Override
    public String[] columns() {
        return COLUMNS;
    }

    @Override
    public List<Map<String, ?>> getStore() {
        return store;
    }
}
