package com.xforceplus.ultraman.metadata.sync.grpc.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ExecutionConfig {

    /**
     * force delete flag
     */
    private Boolean isForce = true;

    /**
     * is legacy
     */
    private Boolean isLegacy = true;

    /**
     *
     */
    private Boolean isOldJoinField = true;

    private Boolean removeIdentifier = false;

    private Boolean auto = true;

    private int initSize = 5;

    private int initTimeout = 10;

    private int prepareTimeInSec = 10;

    /**
     * default is false
     */
    private Boolean usePermission = false;

    private Boolean refreshDNS = false;

    private long refreshDelay = 120;

    private long refreshInterval = 60;

    private List<String> skipRules = Collections.emptyList();

    private Map<String, Integer> rateLimiter = Collections.emptyMap();

    private Boolean useCircuitBreaker = false;

    private int likeType;

    private boolean metadataEnabled = true;

    private int metadataPort = 8182;

    private int queryTimeout = 30000;

    private boolean useCdc = false;

    private String cdcLockKey = "";

    private int slowThreshold = 2000;

    private List<String> dateFormatters = new ArrayList<>();

    public Boolean getLegacy() {
        return isLegacy;
    }

    public int getMetadataPort() {
        return metadataPort;
    }

    public void setMetadataPort(int metadataPort) {
        this.metadataPort = metadataPort;
    }

    public void setLegacy(Boolean legacy) {
        isLegacy = legacy;
    }

    public Boolean getForce() {
        return isForce;
    }

    public void setForce(Boolean force) {
        isForce = force;
    }

    public int getSlowThreshold() {
        return slowThreshold;
    }

    public void setSlowThreshold(int slowThreshold) {
        this.slowThreshold = slowThreshold;
    }

    public void setUsePermission(Boolean usePermission) {
        this.usePermission = usePermission;
    }

    public ExecutionConfig() {
    }

//    public ExecutionConfig(Boolean auto, Boolean isForce, Boolean isLegacy, Boolean isOldJoinField, Boolean removeIdentifier, int initSize, int initTimeout, int prepareTimeInSec, Boolean usePermission) {
//        this.auto = auto;
//        this.isForce = isForce;
//        this.isLegacy = isLegacy;
//        this.initSize = initSize;
//        this.initTimeout = initTimeout;
//        this.isOldJoinField = isOldJoinField;
//        this.prepareTimeInSec = prepareTimeInSec;
//        this.removeIdentifier = removeIdentifier;
//        this.usePermission = usePermission;
//    }

    public int getLikeType() {
        return likeType;
    }

    public void setLikeType(int likeType) {
        this.likeType = likeType;
    }

    public Boolean getUsePermission() {
        return usePermission;
    }

    public int getInitSize() {
        return initSize;
    }

    public void setInitSize(int initSize) {
        this.initSize = initSize;
    }

    public int getInitTimeout() {
        return initTimeout;
    }

    public void setInitTimeout(int initTimeout) {
        this.initTimeout = initTimeout;
    }

    public int getPrepareTimeInSec() {
        return prepareTimeInSec;
    }

    public void setPrepareTimeInSec(int prepareTimeInSec) {
        this.prepareTimeInSec = prepareTimeInSec;
    }

    public Boolean getOldJoinField() {
        return isOldJoinField;
    }

    public void setOldJoinField(Boolean oldJoinField) {
        isOldJoinField = oldJoinField;
    }

    public Boolean getRemoveIdentifier() {
        return removeIdentifier;
    }

    public void setRemoveIdentifier(Boolean removeIdentifier) {
        this.removeIdentifier = removeIdentifier;
    }

    public Boolean getAuto() {
        return auto;
    }

    public void setAuto(Boolean auto) {
        this.auto = auto;
    }

    public Boolean getRefreshDNS() {
        return refreshDNS;
    }

    public void setRefreshDNS(Boolean refreshDNS) {
        this.refreshDNS = refreshDNS;
    }

    public long getRefreshDelay() {
        return refreshDelay;
    }

    public void setRefreshDelay(long refreshDelay) {
        this.refreshDelay = refreshDelay;
    }

    public long getRefreshInterval() {
        return refreshInterval;
    }

    public void setRefreshInterval(long refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public List<String> getSkipRules() {
        return skipRules;
    }

    public void setSkipRules(List<String> skipRules) {
        this.skipRules = skipRules;
    }

    public Map<String, Integer> getRateLimiter() {
        return rateLimiter;
    }

    public void setRateLimiter(Map<String, Integer> rateLimiter) {
        this.rateLimiter = rateLimiter;
    }

    public Boolean getUseCircuitBreaker() {
        return useCircuitBreaker;
    }

    public void setUseCircuitBreaker(Boolean useCircuitBreaker) {
        this.useCircuitBreaker = useCircuitBreaker;
    }

    public int getQueryTimeout() {
        return queryTimeout;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public List<String> getDateFormatters() {
        return dateFormatters;
    }

    public void setDateFormatters(List<String> dateFormatters) {
        this.dateFormatters = dateFormatters;
    }

    public boolean isUseCdc() {
        return useCdc;
    }

    public void setUseCdc(boolean useCdc) {
        this.useCdc = useCdc;
    }

    public String getCdcLockKey() {
        return cdcLockKey;
    }

    public void setCdcLockKey(String cdcLockKey) {
        this.cdcLockKey = cdcLockKey;
    }

    public boolean isMetadataEnabled() {
        return metadataEnabled;
    }

    public void setMetadataEnabled(boolean metadataEnabled) {
        this.metadataEnabled = metadataEnabled;
    }
}
