package com.xforceplus.ultraman.metadata.sync.grpc.service.impl;

import com.xforceplus.tech.base.core.context.ContextKeys.StringKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.metadata.domain.vo.dto.DictItem;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ResponseList;
import com.xforceplus.ultraman.metadata.service.DictService;
import com.xforceplus.ultraman.metadata.sync.grpc.store.DictMapLocalStore;
import com.xforceplus.ultraman.metadata.sync.grpc.store.utils.RowUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.Row;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;


/**
 * move from entityServiceEx
 */
public class DictServiceImpl implements DictService {

    private final ContextService contextService;

    private final DictMapLocalStore dictMapLocalStore;

    public DictServiceImpl(ContextService contextService, DictMapLocalStore dictMapLocalStore) {
        this.dictMapLocalStore = dictMapLocalStore;
        this.contextService = contextService;
    }

    @Override
    public List<DictItem> findDictItems(String enumId, String enumCode, String tenantCode) {
        DataSet ds = null;
        List<Row> rows = new ArrayList<Row>();
        if (StringUtils.isEmpty(enumCode)) {
            if (!StringUtils.isEmpty(tenantCode)) {
                //找到字典的code信息
                ds = dictMapLocalStore.query().selectAll()
                        .where("publishDictId")
                        .eq(enumId)
                        .execute();
                rows = ds.toRows();
                if (rows.size() > 0) {
                    String dictCode = RowUtils.getRowValue(rows.get(0), "dictCode")
                            .map(Object::toString).orElse("");
                    ds = dictMapLocalStore.query().selectAll()
                            .where("dictCode")
                            .eq(dictCode)
                            .and("tenantCode")
                            .eq(tenantCode)
                            .execute();
                }
            }
            if (ds != null) {
                rows = ds.toRows();
            }

            if (!(rows != null && rows.size() > 0)) {
                ds = dictMapLocalStore.query().selectAll()
                        .where("publishDictId")
                        .eq(enumId)
                        .execute();
                rows = ds.toRows();
            }
        } else {
            if (!StringUtils.isEmpty(tenantCode)) {
                if (!StringUtils.isEmpty(tenantCode)) {
                    //找到字典的code信息
                    ds = dictMapLocalStore.query().selectAll()
                            .where("publishDictId")
                            .eq(enumId)
                            .execute();
                    rows = ds.toRows();
                    if (rows.size() > 0) {
                        String dictCode = RowUtils.getRowValue(rows.get(0), "dictCode")
                                .map(Object::toString).orElse("");
                        ds = dictMapLocalStore.query().selectAll()
                                .where("dictCode")
                                .eq(dictCode)
                                .and("tenantCode")
                                .eq(tenantCode)
                                .and("code")
                                .eq(enumCode)
                                .execute();
                    }
                }
            }

            if (ds != null) {
                rows = ds.toRows();
            }

            if (!(rows != null && rows.size() > 0)) {
                ds = dictMapLocalStore.query().selectAll()
                        .where("publishDictId")
                        .eq(enumId)
                        .and("code")
                        .eq(enumCode)
                        .execute();
                rows = ds.toRows();
            }
        }
        List<DictItem> items = rows.stream().map(this::toDictItem).collect(Collectors.toCollection(ResponseList::new));
        return getMaxVersionList(items);
    }

    private List<DictItem> getMaxVersionList(List<DictItem> dictItems) {
        List<DictItem> dictItemList = new ResponseList<>();
        if (dictItems.size() > 0) {
            String maxVersion = dictItems.get(0).getVersion();
            for (int i = 0; i < dictItems.size(); i++) {
                if (compare(maxVersion, dictItems.get(i).getVersion()) < 0) {
                    dictItemList.clear();
                    dictItemList.add(dictItems.get(i));
                    maxVersion = dictItems.get(i).getVersion();
                } else {
                    if (maxVersion.equals(dictItems.get(i).getVersion())) {
                        dictItemList.add(dictItems.get(i));
                    }
                }
            }
        }
        return dictItemList;
    }


    private DictItem toDictItem(Row row) {
        DictItem dictItem = new DictItem();
        dictItem.setText(RowUtils.getRowValue(row, "name").map(Object::toString).orElse(""));
        dictItem.setValue(RowUtils.getRowValue(row, "code").map(Object::toString).orElse(""));
        dictItem.setIcon(RowUtils.getRowValue(row, "icon").map(Object::toString).orElse(""));
        dictItem.setVersion(RowUtils.getRowValue(row, "version").map(Object::toString).orElse(""));
        dictItem.setDictId(RowUtils.getRowValue(row, "publishDictId").map(Object::toString).orElse(""));
        dictItem.setDictCode(RowUtils.getRowValue(row, "dictCode").map(Object::toString).orElse(""));
        dictItem.setDictName(RowUtils.getRowValue(row, "dictName").map(Object::toString).orElse(""));
        return dictItem;
    }

    /**
     * 版本对比方法
     *
     * @param v1
     * @param v2
     * @return
     */
    public int compare(String v1, String v2) {
        if (StringUtils.isEmpty(v1) && StringUtils.isEmpty(v2)) {
            return 0;
        } else if (StringUtils.isEmpty(v1)) {
            return -1;
        } else if (StringUtils.isEmpty(v2)) {
            return 1;
        }

        int[] varr1 = getVersionArray(v1);

        int[] varr2 = getVersionArray(v2);

        int lim = Math.min(varr1.length, varr2.length);

        int k = 0;
        while (k < lim) {
            if (varr1[k] == varr2[k]) {
                k++;
                continue;
            }
            return varr1[k] > varr2[k] ? 1 : -1;
        }

        if (varr1.length == varr2.length) {
            return 0;
        }

        return varr1.length > varr2.length ? 1 : -1;
    }

    public int[] getVersionArray(String v) {
        String[] sarray = StringUtils.split(v, ".");

        int[] varray = new int[sarray.length];

        int k = 0;

        while (k < sarray.length) {
            varray[k] = Integer.parseInt(sarray[k]);
            k++;
        }

        return varray;
    }

    @Override
    public List<DictItem> findDictItemsByCode(String code, String enumCode, String tenantCode) {

        DataSet ds = null;
        List<Row> rows = new ArrayList<Row>();
        if (StringUtils.isEmpty(enumCode)) {
            if (!StringUtils.isEmpty(tenantCode)) {
                ds = dictMapLocalStore.query().selectAll()
                        .where("dictCode")
                        .eq(code)
                        .and("tenantCode")
                        .eq(tenantCode)
                        .execute();
            }

            if (ds != null) {
                rows = ds.toRows();
            }

            if (!(rows != null && rows.size() > 0)) {
                ds = dictMapLocalStore.query().selectAll()
                        .where("dictCode")
                        .eq(code)
                        .execute();
                rows = ds.toRows();
            }
        } else {
            if (!StringUtils.isEmpty(tenantCode)) {
                ds = dictMapLocalStore.query().selectAll()
                        .where("dictCode")
                        .eq(code)
                        .and("tenantCode")
                        .eq(tenantCode)
                        .and("code")
                        .eq(enumCode)
                        .execute();
            }

            if (ds != null) {
                rows = ds.toRows();
            }

            if (!(rows != null && rows.size() > 0)) {
                ds = dictMapLocalStore.query().selectAll()
                        .where("dictCode")
                        .eq(code)
                        .and("code")
                        .eq(enumCode)
                        .execute();
                rows = ds.toRows();
            }
        }
        List<DictItem> items = rows.stream().map(this::toDictItem).collect(Collectors.toCollection(ResponseList::new));
        return getMaxVersionList(items);
    }

    @Override
    public List<DictItem> findAllDictItems(String tenantCode) {
        DataSet ds = null;
        List<Row> rows = new ArrayList<Row>();
        if (!StringUtils.isEmpty(tenantCode)) {
            if (!StringUtils.isEmpty(tenantCode)) {
                //找到字典的code信息
                ds = dictMapLocalStore.query().selectAll()
                        .execute();
                rows = ds.toRows();
                if (rows.size() > 0) {
                    String dictCode = RowUtils.getRowValue(rows.get(0), "dictCode")
                            .map(Object::toString).orElse("");
                    ds = dictMapLocalStore.query().selectAll()
                            .where("dictCode")
                            .eq(dictCode)
                            .and("tenantCode")
                            .eq(tenantCode)
                            .execute();
                }
            }
        } else {
            ds = dictMapLocalStore.query().selectAll()
                    .execute();
            rows = ds.toRows();
            if (rows.size() > 0) {
                String dictCode = RowUtils.getRowValue(rows.get(0), "dictCode")
                        .map(Object::toString).orElse("");
                ds = dictMapLocalStore.query().selectAll()
                        .where("dictCode")
                        .eq(dictCode)
                        .execute();
            }
        }
        List<DictItem> items = rows.stream().map(this::toDictItem).collect(Collectors.toCollection(ResponseList::new));
        return getMaxVersionList(items);
    }

    @Override
    public List<DictItem> findAllDictItems() {
        String tenantCode = contextService.get(StringKeys.TENANTCODE_KEY);
        return findAllDictItems(tenantCode);
    }

    @Override
    public Integer findEnumIndex(List<DictItem> dictItems, String value) {
        return 0;
    }

    @Override
    public List<DictItem> findDictItems(String enumId, String enumCode) {
        String tenantCode = contextService.get(StringKeys.TENANTCODE_KEY);
        return findDictItems(enumId, enumCode, tenantCode);
    }

    @Override
    public List<DictItem> findDictItems(String enumId, String enumCode, Map<String, Object> context) {
        String tenantCode = Optional.ofNullable(context.get(StringKeys.TENANTCODE_KEY.name())).map(x -> x.toString()).orElse(null);
        return findDictItems(enumId, enumCode, tenantCode);
    }

    @Override
    public List<DictItem> findDictItemsByCode(String code, String enumCode) {
        String tenantCode = contextService.get(StringKeys.TENANTCODE_KEY);
        return findDictItemsByCode(code, enumCode, tenantCode);
    }
}
