/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.sync.grpc.listener;

import com.xforceplus.metadata.schema.runtime.MetadataEngine;
import com.xforceplus.metadata.schema.typed.AppNode;
import com.xforceplus.ultraman.metadata.component.GlobalInited;
import com.xforceplus.ultraman.metadata.grpc.ModuleUpResult;
import com.xforceplus.ultraman.metadata.sync.grpc.config.ExecutionConfig;
import com.xforceplus.ultraman.metadata.sync.grpc.event.MetadataModuleGotEvent;
import com.xforceplus.ultraman.metadata.sync.grpc.event.MetadataModulePrepareResultEvent;
import com.xforceplus.ultraman.metadata.sync.grpc.event.MetadataModulePreparedErrorEvent;
import com.xforceplus.ultraman.metadata.sync.grpc.event.MetadataModulePreparedEvent;
import com.xforceplus.ultraman.metadata.sync.grpc.utils.DomainConverter;
import com.xforceplus.ultraman.sdk.infra.base.AuthConfig;
import com.xforceplus.ultraman.sdk.infra.event.EventEngine;
import com.xforceplus.ultraman.sdk.infra.event.UltramanLifecycle;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.concurrent.CompletableToListenableFutureAdapter;
import org.springframework.util.concurrent.ListenableFuture;

public class ModuleEventListener {
    private static final Logger log = LoggerFactory.getLogger(ModuleEventListener.class);
    @Autowired
    private MetadataEngine metadataEngine;
    @Autowired
    private EventEngine engine;
    @Autowired
    public GlobalInited globalInited;
    private ExecutionConfig executionConfig;
    private AuthConfig authConfig;

    public ModuleEventListener(ExecutionConfig config, AuthConfig authConfig) {
        this.executionConfig = config;
        this.authConfig = authConfig;
    }

    private List<MetadataModulePrepareResultEvent> skipPrepare(MetadataModuleGotEvent event) {
        List<ModuleUpResult> response = event.getResponse();
        return response.stream().map(x -> new MetadataModulePreparedEvent((ModuleUpResult)x, event.getRequest().getTenantId(), event.getRequest().getAppId())).collect(Collectors.toList());
    }

    @Order
    @EventListener(value={MetadataModuleGotEvent.class})
    public ListenableFuture<List<MetadataModulePrepareResultEvent>> saveMetadata(MetadataModuleGotEvent event) {
        return new CompletableToListenableFutureAdapter(CompletableFuture.completedFuture(this.skipPrepare(event)));
    }

    @EventListener(value={MetadataModulePreparedEvent.class})
    public void cleanUpdateAndSave(MetadataModulePreparedEvent preparedEvent) {
        MetadataModulePreparedEvent preparedEventType = preparedEvent;
        ModuleUpResult module = preparedEventType.getModuleUpResult();
        AppNode appNode = DomainConverter.toAppNode(module);
        this.metadataEngine.save(appNode);
        this.globalInited.moduleSaved();
        this.engine.trigger(UltramanLifecycle.METADATA_REFRESHED, (Object)appNode);
    }

    @Async
    @EventListener(value={MetadataModulePreparedErrorEvent.class})
    public void recordFailed(MetadataModulePreparedErrorEvent errorEvent) {
        MetadataModulePreparedErrorEvent errorEventType = errorEvent;
    }
}

