/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.sync.grpc.store;

import com.xforceplus.ultraman.metadata.sync.grpc.store.utils.RowUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.metamodel.UpdateScript;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.delete.DeleteFrom;
import org.apache.metamodel.insert.InsertInto;
import org.apache.metamodel.pojo.MapTableDataProvider;
import org.apache.metamodel.pojo.PojoDataContext;
import org.apache.metamodel.pojo.TableDataProvider;
import org.apache.metamodel.query.CompiledQuery;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.OperatorType;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.query.QueryParameter;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.query.builder.TableFromBuilder;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.update.Update;
import org.apache.metamodel.util.SimpleTableDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapLocalStore {
    private Logger logger = LoggerFactory.getLogger(MapLocalStore.class);
    private String schema;
    private String tableName;
    private String[] columns;
    private String[] allColumns;
    private final SimpleTableDef tableDef;
    protected final PojoDataContext dc;
    private final TableDataProvider<?> tableDataProvider;
    private final Table table;
    private final List<Map<String, ?>> maps = new ArrayList();
    private CompiledQuery pkQuery = null;
    private Comparator<Object> versionComparator;
    private String[] pks;
    private boolean hasVersion;
    private String versioned = "version";
    private Column versionedColumn;
    private Integer maxVersion = 3;

    public MapLocalStore(String schema, String tableName, String[] columns, String[] pkColumns, boolean hasVersion, Comparator<Object> versionComparator) {
        this.columns = columns;
        this.schema = schema;
        this.tableName = tableName;
        this.pks = pkColumns;
        this.hasVersion = hasVersion;
        this.versionComparator = versionComparator;
        Integer length = (this.pks == null ? 0 : this.pks.length) + columns.length;
        this.allColumns = new String[length.intValue()];
        for (int i = 0; i < this.allColumns.length; ++i) {
            this.allColumns[i] = this.pks != null && this.pks.length > 0 && i < this.pks.length ? this.pks[i] : columns[i - (this.pks == null ? 0 : this.pks.length)];
        }
        this.tableDef = new SimpleTableDef(tableName, this.allColumns);
        this.tableDataProvider = new MapTableDataProvider(this.tableDef, this.maps);
        this.table = this.tableDef.toTable();
        this.dc = new PojoDataContext(schema, new TableDataProvider[]{this.tableDataProvider});
        if (hasVersion) {
            this.versionedColumn = this.table.getColumnByName(this.versioned);
        }
        if (this.pks != null) {
            List filterItems = Stream.of(this.pks).map(pk -> new SelectItem(this.dc.getColumnByQualifiedLabel(schema + "." + tableName + "." + pk))).map(pk -> new FilterItem(pk, OperatorType.EQUALS_TO, (Object)new QueryParameter())).collect(Collectors.toList());
            Query query = this.dc.query().from(tableName).selectAll().where(filterItems).toQuery();
            this.pkQuery = this.dc.compileQuery(query);
        }
    }

    public synchronized void save(Map<String, Object> record) {
        if (this.hasPk(record).booleanValue()) {
            if (this.pks != null) {
                List<Row> pkRow = this.getSamePkRecord(record);
                if (!pkRow.isEmpty()) {
                    if (this.hasVersion && this.hasVersion(record).booleanValue()) {
                        if (pkRow.stream().map(x -> RowUtils.getRowValue(x, this.versioned)).anyMatch(x -> x.equals(record.get(this.versioned)))) {
                            this.logger.debug("Same version found {}", record);
                            return;
                        }
                        if (pkRow.size() < this.maxVersion) {
                            this.insert(record);
                        } else {
                            Row toBeDeleted = (Row)pkRow.stream().max((x, y) -> {
                                Object xVersion = x.getValue(this.versionedColumn);
                                Object yVersion = y.getValue(this.versionedColumn);
                                return this.versionComparator.compare(xVersion, yVersion);
                            }).get();
                            this.dc.executeUpdate((UpdateScript)new DeleteFrom(this.table).where(this.rowToFilterItem(toBeDeleted)));
                            this.insert(record);
                        }
                    } else {
                        this.update(record);
                    }
                } else {
                    this.insert(record);
                }
            } else {
                this.insert(record);
            }
        } else {
            this.insert(record);
        }
    }

    public Table getTable() {
        return this.table;
    }

    private synchronized void insert(Map<String, Object> record) {
        InsertInto insert = new InsertInto(this.table);
        for (int i = 0; i < this.allColumns.length; ++i) {
            if (record.get(this.allColumns[i]) == null) continue;
            insert.value(this.allColumns[i], record.get(this.allColumns[i]));
        }
        this.dc.executeUpdate((UpdateScript)insert);
    }

    public void update(Map<String, Object> record, Map<String, Object> condition) {
        List filterItems = condition.entrySet().stream().map(entry -> {
            SelectItem selectItem = new SelectItem(this.table.getColumnByName((String)entry.getKey()));
            return new FilterItem(selectItem, OperatorType.EQUALS_TO, entry.getValue());
        }).collect(Collectors.toList());
        Update update = new Update(this.table).where(filterItems);
        for (int i = 0; i < this.columns.length; ++i) {
            if (record.get(this.columns[i]) == null) continue;
            update.value(this.columns[i], record.get(this.columns[i]));
        }
        this.dc.executeUpdate((UpdateScript)update);
    }

    private void update(Map<String, Object> record) {
        List filterItems = Stream.of(this.pks).map(pk -> new SelectItem(this.table.getColumnByName(pk))).map(pk -> new FilterItem(pk, OperatorType.EQUALS_TO, record.get(pk.getColumn().getName()))).collect(Collectors.toList());
        Update update = new Update(this.table).where(filterItems);
        for (int i = 0; i < this.columns.length; ++i) {
            if (record.get(this.columns[i]) == null) continue;
            update.value(this.columns[i], record.get(this.columns[i]));
        }
        this.dc.executeUpdate((UpdateScript)update);
    }

    private Boolean hasVersion(Map<String, Object> record) {
        return record.containsKey(this.versioned);
    }

    private Boolean hasPk(Map<String, Object> record) {
        if (this.pks != null) {
            return Stream.of(this.pks).allMatch(record::containsKey);
        }
        return true;
    }

    public TableFromBuilder query() {
        return this.dc.query().from(this.table);
    }

    private List<Row> getSamePkRecord(Map<String, Object> record) {
        DataSet result = this.dc.executeQuery(this.pkQuery, this.getPk(record));
        return result.toRows();
    }

    private List<FilterItem> rowToFilterItem(Row row) {
        return row.getSelectItems().stream().map(x -> new FilterItem(new SelectItem(this.table.getColumnByName(x.getColumn().getName())), OperatorType.EQUALS_TO, row.getValue(x.getColumn()))).collect(Collectors.toList());
    }

    private List<FilterItem> mapToFilterItem(Map<String, Object> row) {
        ArrayList<FilterItem> list = new ArrayList<FilterItem>();
        for (int i = 0; i < this.allColumns.length; ++i) {
            Column column = this.table.getColumnByName(this.allColumns[i]);
            if (row.get(this.allColumns[i]) == null) continue;
            list.add(new FilterItem(new SelectItem(column), OperatorType.EQUALS_TO, row.get(this.allColumns[i])));
        }
        return list;
    }

    private Object[] getPk(Map<String, Object> record) {
        Object[] pkValues = new Object[this.pks.length];
        for (int i = 0; i < this.pks.length; ++i) {
            pkValues[i] = record.get(this.pks[i]);
        }
        return pkValues;
    }

    public SelectItem getRowColumn(Row row, String columnName) {
        Optional<SelectItem> opItem = row.getSelectItems().stream().filter(x -> x.getColumn().getName().equals(columnName)).findAny();
        return opItem.get();
    }

    public Optional<Object> getRowValue(Row row, String columnName) {
        Optional<SelectItem> opItem = row.getSelectItems().stream().filter(x -> x.getColumn().getName().equals(columnName)).findAny();
        return opItem.map(arg_0 -> ((Row)row).getValue(arg_0));
    }
}

