/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.sync.grpc.store.repository.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ApiDetails;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ApiItem;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ApiRule;
import com.xforceplus.ultraman.metadata.domain.vo.dto.AppItem;
import com.xforceplus.ultraman.metadata.domain.vo.dto.BoApiVo;
import com.xforceplus.ultraman.metadata.domain.vo.dto.BoFieldVo;
import com.xforceplus.ultraman.metadata.domain.vo.dto.BoInfoVo;
import com.xforceplus.ultraman.metadata.domain.vo.dto.BoItem;
import com.xforceplus.ultraman.metadata.domain.vo.dto.CurrentVersion;
import com.xforceplus.ultraman.metadata.domain.vo.dto.FieldItem;
import com.xforceplus.ultraman.metadata.domain.vo.dto.RelationshipVo;
import com.xforceplus.ultraman.metadata.domain.vo.dto.SimpleBoItem;
import com.xforceplus.ultraman.metadata.domain.vo.dto.SoloItem;
import com.xforceplus.ultraman.metadata.entity.FieldLikeRelationType;
import com.xforceplus.ultraman.metadata.entity.FieldType;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.entity.legacy.impl.EntityClass;
import com.xforceplus.ultraman.metadata.entity.legacy.impl.Relation;
import com.xforceplus.ultraman.metadata.grpc.Api;
import com.xforceplus.ultraman.metadata.grpc.AppUp;
import com.xforceplus.ultraman.metadata.grpc.BoUp;
import com.xforceplus.ultraman.metadata.grpc.Field;
import com.xforceplus.ultraman.metadata.grpc.ModuleUpResult;
import com.xforceplus.ultraman.metadata.sync.grpc.store.VersionService;
import com.xforceplus.ultraman.metadata.sync.grpc.store.impl.BoNode;
import com.xforceplus.ultraman.metadata.sync.grpc.store.impl.DefaultVersionService;
import com.xforceplus.ultraman.metadata.sync.grpc.store.impl.tables.ApiTable;
import com.xforceplus.ultraman.metadata.sync.grpc.store.impl.tables.AppTable;
import com.xforceplus.ultraman.metadata.sync.grpc.store.impl.tables.BoTable;
import com.xforceplus.ultraman.metadata.sync.grpc.store.impl.tables.FieldTable;
import com.xforceplus.ultraman.metadata.sync.grpc.store.impl.tables.ModuleTable;
import com.xforceplus.ultraman.metadata.sync.grpc.store.impl.tables.RelationTable;
import com.xforceplus.ultraman.metadata.sync.grpc.store.repository.LegacyMetadataRepository;
import com.xforceplus.ultraman.metadata.sync.grpc.store.utils.FieldHelper;
import com.xforceplus.ultraman.metadata.sync.grpc.store.utils.RowUtils;
import com.xforceplus.ultraman.metadata.sync.grpc.utils.VersionUtils;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.metamodel.UpdateScript;
import org.apache.metamodel.UpdateSummary;
import org.apache.metamodel.UpdateableDataContext;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.delete.DeleteFrom;
import org.apache.metamodel.delete.RowDeletionBuilder;
import org.apache.metamodel.insert.InsertInto;
import org.apache.metamodel.pojo.MapTableDataProvider;
import org.apache.metamodel.pojo.PojoDataContext;
import org.apache.metamodel.pojo.TableDataProvider;
import org.apache.metamodel.query.builder.SatisfiedWhereBuilder;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.SimpleTableDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;

public class MetadataRepositoryInMemoryImpl
implements LegacyMetadataRepository {
    private static final Logger log = LoggerFactory.getLogger(MetadataRepositoryInMemoryImpl.class);
    private ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private VersionService versionService;
    private int maxVersion = 3;
    private static String DEFAULT_PROFILE = "";
    private ObjectMapper mapper;
    private static String[] preserved = new String[]{"query", "queryOne", "create", "update", "delete", "batchUpdate", "batchAdd", "batchDelete"};

    public MetadataRepositoryInMemoryImpl() {
        this(null, -1, null);
    }

    public MetadataRepositoryInMemoryImpl(ObjectMapper mapper, int maxVersion, ApplicationEventPublisher publisher) {
        if (maxVersion > 0) {
            this.maxVersion = maxVersion;
        }
        this.versionService = new DefaultVersionService(this.maxVersion, publisher);
        this.versionService.initVersionedDC(this.maxVersion, this::generateNewDC);
        if (mapper == null) {
            mapper = new ObjectMapper();
        }
        this.mapper = mapper;
    }

    @Override
    public List<String> codes() {
        return this.read(() -> this.versionService.getBoModuleMapping().entrySet().stream().map(x -> ((BoNode)x.getKey()).getCode()).collect(Collectors.toList()));
    }

    private UpdateableDataContext generateNewDC() {
        TableDataProvider[] tableDataProviders = (TableDataProvider[])Stream.of(new ModuleTable(), new BoTable(), new ApiTable(), new FieldTable(), new RelationTable(), new AppTable()).map(x -> {
            SimpleTableDef tableDef = new SimpleTableDef(x.name(), x.columns());
            return new MapTableDataProvider(tableDef, x.getStore());
        }).toArray(TableDataProvider[]::new);
        return new PojoDataContext("metadata", tableDataProviders);
    }

    private Map<String, ApiItem> toApiItemMap(DataSet apis) {
        HashMap<String, ApiItem> map = new HashMap<String, ApiItem>();
        while (apis.next()) {
            Row row = apis.getRow();
            String code = RowUtils.getRowValue(row, "code").map(String::valueOf).orElse("");
            String url = RowUtils.getRowValue(row, "url").map(String::valueOf).orElse("");
            String method = RowUtils.getRowValue(row, "method").map(String::valueOf).orElse("");
            ApiItem apiItem = new ApiItem(url, method);
            map.put(code, apiItem);
        }
        return map;
    }

    private List<FieldItem> toFieldItemList(DataSet fields) {
        ArrayList<FieldItem> items = new ArrayList<FieldItem>();
        while (fields.next()) {
            Row row = fields.getRow();
            FieldItem fieldItem = new FieldItem();
            fieldItem.setCode(RowUtils.getRowValue(row, "code").map(String::valueOf).orElse(""));
            fieldItem.setDisplayType(RowUtils.getRowValue(row, "displayType").map(String::valueOf).orElse(""));
            fieldItem.setEditable(RowUtils.getRowValue(row, "editable").map(String::valueOf).orElse(""));
            fieldItem.setEnumCode(RowUtils.getRowValue(row, "enumCode").map(String::valueOf).orElse(""));
            fieldItem.setMaxLength(RowUtils.getRowValue(row, "maxLength").map(String::valueOf).orElse(""));
            fieldItem.setName(RowUtils.getRowValue(row, "name").map(String::valueOf).orElse(""));
            fieldItem.setRequired(RowUtils.getRowValue(row, "required").map(String::valueOf).orElse(""));
            fieldItem.setType(RowUtils.getRowValue(row, "fieldType").map(String::valueOf).orElse(""));
            fieldItem.setSearchable(RowUtils.getRowValue(row, "searchable").map(String::valueOf).orElse(""));
            fieldItem.setDictId(RowUtils.getRowValue(row, "dictId").map(String::valueOf).orElse(""));
            fieldItem.setDefaultValue(RowUtils.getRowValue(row, "defaultValue").map(String::valueOf).orElse(""));
            fieldItem.setPrecision(RowUtils.getRowValue(row, "precision").map(String::valueOf).orElse(""));
            fieldItem.setUniqueName(RowUtils.getRowValue(row, "uniqueName").map(String::valueOf).orElse(""));
            fieldItem.setRelationshipEntity(null);
            items.add(fieldItem);
        }
        return items;
    }

    private <T> T read(Supplier<T> supplier) {
        this.rwLock.readLock().lock();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    private void write(Supplier<Void> supplier) {
        this.rwLock.writeLock().lock();
        try {
            supplier.get();
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public BoItem getBoDetailById(String id, String profile) {
        return this.read(() -> {
            Tuple2<String, UpdateableDataContext> dcTuple = this.versionService.getCurrentVersionDCForBoById(Long.parseLong(id));
            UpdateableDataContext dc = (UpdateableDataContext)dcTuple._2;
            if (dc == null) {
                return null;
            }
            DataSet boDetails = ((SatisfiedWhereBuilder)dc.query().from("bos").selectAll().where("id").eq(id)).execute();
            if (boDetails.next()) {
                Row ds = boDetails.getRow();
                DataSet apis = ((SatisfiedWhereBuilder)((SatisfiedWhereBuilder)dc.query().from("apis").selectAll().where("boId").eq(id)).and("profile").in(new String[]{profile, DEFAULT_PROFILE})).execute();
                Map<String, ApiItem> apiItemMap = this.toApiItemMap(apis);
                DataSet fields = ((SatisfiedWhereBuilder)((SatisfiedWhereBuilder)dc.query().from("fields").selectAll().where("boId").eq(id)).and("profile").in(new String[]{profile, DEFAULT_PROFILE})).execute();
                List<FieldItem> fieldItemList = this.toFieldItemList(fields);
                DataSet rels = ((SatisfiedWhereBuilder)((SatisfiedWhereBuilder)dc.query().from("rels").selectAll().where("boId").eq(id)).and("profile").in(new String[]{profile, DEFAULT_PROFILE})).execute();
                List rows = rels.toRows();
                List relIds = rows.stream().map(x -> RowUtils.getRowValue(x, "joinBoId").map(String::valueOf).orElse("")).collect(Collectors.toList());
                List<FieldItem> relField = this.loadRelationField(rows, row -> {
                    String joinBoId = RowUtils.getRowValue(row, "joinBoId").map(String::valueOf).orElse("");
                    DataSet boDs = ((SatisfiedWhereBuilder)dc.query().from("bos").selectAll().where("id").eq(joinBoId)).execute();
                    if (boDs.next()) {
                        Row bo = boDs.getRow();
                        String boCode = RowUtils.getRowValue(bo, "code").map(String::valueOf).orElse("");
                        SoloItem soloItem = new SoloItem();
                        soloItem.setId(Long.valueOf(joinBoId));
                        return new FieldItem(boCode.concat(".id"), boCode.concat(".id"), FieldType.LONG.getType(), "", "false", "true", "false", null, null, "0", "", "", soloItem, "");
                    }
                    return null;
                });
                LinkedList<FieldItem> fieldTotalItems = new LinkedList<FieldItem>();
                fieldTotalItems.addAll(fieldItemList);
                fieldTotalItems.addAll(relField);
                BoItem boItem = new BoItem();
                boItem.setApi(apiItemMap);
                boItem.setFields(fieldTotalItems);
                boItem.setParentEntityId(RowUtils.getRowValue(ds, "parentId").map(String::valueOf).orElse(""));
                boItem.setSubEntities(relIds);
                return boItem;
            }
            return null;
        });
    }

    @Override
    public void save(ModuleUpResult moduleUpResult, String tenantId, String appId) {
        this.write(() -> {
            this.saveApp(moduleUpResult.getAppUp(), this.versionService.getGlobalDC());
            String version = moduleUpResult.getVersion();
            long moduleId = moduleUpResult.getId();
            log.info("------- Version {} Got For {}", (Object)version, (Object)moduleId);
            this.versionService.saveModule(moduleId, version, moduleUpResult.getBoUpsList().stream().flatMap(x -> {
                Stream<BoNode> single = Stream.of(new BoNode(x.getCode(), Long.parseLong(x.getId())));
                Stream<BoNode> nestOne = x.getBoUpsList().stream().map(sub -> new BoNode(sub.getCode(), Long.parseLong(sub.getId())));
                return Stream.concat(single, nestOne);
            }).collect(Collectors.toList()));
            UpdateableDataContext versionedDCForModule = this.versionService.getVersionedDCForModule(moduleId, version);
            this.clearCurrentModule(moduleId, versionedDCForModule);
            moduleUpResult.getBoUpsList().forEach(boUp -> {
                this.insertBo(moduleId, (BoUp)boUp, versionedDCForModule);
                log.info("Insert Bo:{}", (Object)boUp.getId());
            });
            return null;
        });
    }

    private void clearCurrentModule(long moduleId, UpdateableDataContext dc) {
        this.write(() -> {
            DataSet boIds = ((SatisfiedWhereBuilder)dc.query().from(this.getTable("bos", dc)).select("id").where("moduleId").eq((Number)moduleId)).execute();
            boIds.toRows().forEach(x -> {
                String boId = x.getValue(0).toString();
                log.info("Clear Bo:{}", (Object)boId);
                this.clearAllBoIdRelated(boId, moduleId, dc);
            });
            return null;
        });
    }

    private Optional<IEntityClass> loadParentEntityClassWithRelation(String boId, String profile, UpdateableDataContext dc, String ver) {
        return this.read(() -> Optional.ofNullable(dc).flatMap(x -> {
            DataSet boDs = ((SatisfiedWhereBuilder)dc.query().from("bos").selectAll().where("id").eq(boId)).execute();
            if (boDs.next()) {
                Row row = boDs.getRow();
                String code = RowUtils.getRowValue(row, "code").map(String::valueOf).orElse("");
                List<IEntityField> entityFields = this.loadFields(boId, profile, dc);
                DataSet relDs = ((SatisfiedWhereBuilder)dc.query().from("rels").selectAll().where("boId").eq(boId)).execute();
                List relsRows = relDs.toRows();
                List<Tuple2> relatedEntityClassList = relsRows.stream().map(relRow -> {
                    Optional<String> relatedBoIdOp = RowUtils.getRowValue(relRow, "joinBoId").map(String::valueOf);
                    return relatedBoIdOp.flatMap(relBo -> this.loadRelationEntityClass(boId, (String)relBo, (Row)relRow, code, dc, profile, ver));
                }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
                LinkedList entityClassList = new LinkedList();
                LinkedList relationList = new LinkedList();
                LinkedList<IEntityField> allFields = new LinkedList<IEntityField>();
                allFields.addAll(entityFields);
                relatedEntityClassList.forEach(tuple -> {
                    entityClassList.add(tuple._2());
                    relationList.add(tuple._1());
                });
                relationList.stream().filter(rel -> FieldLikeRelationType.from((String)rel.getRelationType()).map(FieldLikeRelationType::isOwnerSide).orElse(false)).forEach(rel -> allFields.add(rel.getEntityField()));
                return Optional.of(new EntityClass(Long.valueOf(boId).longValue(), VersionUtils.toVersionInt(ver).intValue(), code, Collections.emptyList(), Collections.emptyList(), null, Collections.emptyList(), allFields));
            }
            return Optional.empty();
        }));
    }

    private Optional<IEntityClass> loadParentEntityClassWithoutRelation(String boId, UpdateableDataContext dc, String profile, String ver) {
        return this.read(() -> Optional.ofNullable(dc).flatMap(x -> {
            DataSet boDs = ((SatisfiedWhereBuilder)dc.query().from("bos").selectAll().where("id").eq(boId)).execute();
            if (boDs.next()) {
                Row row = boDs.getRow();
                String code = RowUtils.getRowValue(row, "code").map(String::valueOf).orElse("");
                List<IEntityField> entityFields = this.loadFields(boId, profile, dc);
                return Optional.of(new EntityClass(Long.valueOf(boId).longValue(), VersionUtils.toVersionInt(ver).intValue(), code, Collections.emptyList(), Collections.emptyList(), null, Collections.emptyList(), entityFields));
            }
            return Optional.empty();
        }));
    }

    private Optional<Tuple2<Relation, IEntityClass>> loadRelationEntityClass(String ownerId, String boId, Row relRow, String mainBoCode, UpdateableDataContext contextDC, String profile, String ver) {
        return this.read(() -> {
            String relationType = RowUtils.getRowValue(relRow, "relType").map(String::valueOf).orElse("");
            String name = RowUtils.getRowValue(relRow, "relName").map(String::valueOf).orElse("");
            Long joinBoId = RowUtils.getRowValue(relRow, "joinBoId").map(String::valueOf).map(Long::valueOf).orElse(0L);
            Long relId = RowUtils.getRowValue(relRow, "id").map(String::valueOf).map(Long::valueOf).orElse(0L);
            return this.findOneById("bos", boId, contextDC).map(row -> {
                Optional parentEntityClass = RowUtils.getRowValue(row, "parentId").map(String::valueOf).flatMap(x -> this.loadParentEntityClassWithoutRelation((String)x, contextDC, profile, ver));
                String subCode = RowUtils.getRowValue(row, "code").map(String::valueOf).orElse("");
                LinkedList<IEntityField> listFields = new LinkedList<IEntityField>();
                Relation relation = new Relation(relId, name, joinBoId.longValue(), subCode, mainBoCode, relationType);
                relation.setRelOwnerClassId(Long.parseLong(ownerId));
                FieldLikeRelationType.from((String)relationType).ifPresent(x -> {
                    IEntityField relField = x.getField(relation);
                    relation.setEntityField(relField);
                    if (!x.isOwnerSide()) {
                        listFields.add(relField);
                    }
                });
                listFields.addAll(this.loadFields(boId, profile, contextDC));
                EntityClass entityClass = new EntityClass(Long.valueOf(boId).longValue(), VersionUtils.toVersionInt(ver).intValue(), subCode, Collections.emptyList(), Collections.emptyList(), (IEntityClass)parentEntityClass.orElse(null), Collections.emptyList(), listFields);
                return Tuple.of((Object)relation, (Object)entityClass);
            });
        });
    }

    @Override
    public Optional<IEntityClass> loadByCode(String tenantId, String appCode, String boCode, String profile) {
        return this.read(() -> {
            Tuple2<String, UpdateableDataContext> currentVersionDCForBoByCode = this.versionService.getCurrentVersionDCForBoByCode(boCode);
            if (currentVersionDCForBoByCode != null) {
                String appVersion = this.getCurrentModuleVersion();
                String boVersion = (String)currentVersionDCForBoByCode._1();
                if (!boVersion.equals(appVersion)) {
                    return Optional.empty();
                }
            }
            UpdateableDataContext dc = Optional.ofNullable(currentVersionDCForBoByCode).map(Tuple2::_2).orElse(null);
            return Optional.ofNullable(dc).flatMap(contextDC -> this.loadByCode(tenantId, appCode, boCode, (UpdateableDataContext)contextDC, profile, (String)currentVersionDCForBoByCode._1()));
        });
    }

    @Override
    public List<IEntityClass> findSubEntitiesById(String tenantId, String appId, String parentId, String profile) {
        return this.read(() -> {
            String appVersion = this.getCurrentModuleVersion();
            return Optional.ofNullable(this.versionService.getCurrentVersionDCForBoById(Long.parseLong(parentId))).filter(x -> ((String)x._1()).equals(appVersion)).map(x -> this.findSubEntitiesById(tenantId, appId, parentId, (UpdateableDataContext)x._2(), profile, (String)x._1())).orElseGet(Collections::emptyList);
        });
    }

    @Override
    public List<IEntityClass> findSubEntitiesById(String tenantId, String appId, String parentId, String profile, String version) {
        return this.read(() -> Optional.ofNullable(this.versionService.getVersionedDCForBoById(Long.parseLong(parentId), version)).map(x -> this.findSubEntitiesById(tenantId, appId, parentId, (UpdateableDataContext)x, profile, version)).orElseGet(Collections::emptyList));
    }

    private List<IEntityClass> findSubEntitiesById(String tenantId, String appId, String parentId, UpdateableDataContext contextDC, String profile, String ver) {
        return this.read(() -> {
            DataSet boDs = ((SatisfiedWhereBuilder)contextDC.query().from("bos").selectAll().where("parentId").eq(parentId)).execute();
            List rows = boDs.toRows();
            return rows.stream().map(row -> this.toEntityClass((Row)row, contextDC, profile, ver)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        });
    }

    private List<IEntityClass> findSubEntitiesByCode(String tenantId, String appId, String parentCode, UpdateableDataContext contextDC, String profile) {
        return this.read(() -> {
            DataSet boDs = ((SatisfiedWhereBuilder)contextDC.query().from("bos").selectAll().where("code").eq(parentCode)).execute();
            if (boDs.next()) {
                String id = RowUtils.getRowValue(boDs.getRow(), "id").map(String::valueOf).orElse("");
                return this.findSubEntitiesById(tenantId, appId, id, profile);
            }
            return Collections.emptyList();
        });
    }

    @Override
    public List<IEntityClass> findSubEntitiesByCode(String tenantId, String appId, String parentCode, String profile) {
        return this.read(() -> {
            Tuple2<String, UpdateableDataContext> currentVersionDCForBoByCode = this.versionService.getCurrentVersionDCForBoByCode(parentCode);
            if (currentVersionDCForBoByCode != null) {
                String boVersion;
                String appVersion = this.getCurrentModuleVersion();
                if (!appVersion.equals(boVersion = (String)currentVersionDCForBoByCode._1)) {
                    return Collections.emptyList();
                }
            } else {
                return Collections.emptyList();
            }
            UpdateableDataContext contextDC = (UpdateableDataContext)currentVersionDCForBoByCode._2();
            return Optional.ofNullable(contextDC).map(x -> this.findSubEntitiesByCode(tenantId, appId, parentCode, (UpdateableDataContext)x, profile)).orElseGet(Collections::emptyList);
        });
    }

    @Override
    public List<IEntityClass> findSubEntitiesByCode(String tenantId, String appId, String parentCode, String profile, String version) {
        return this.read(() -> {
            UpdateableDataContext contextDC = this.versionService.getVersionedDCForBoByCode(parentCode, version);
            return Optional.ofNullable(contextDC).map(x -> this.findSubEntitiesByCode(tenantId, appId, parentCode, (UpdateableDataContext)x, profile)).orElseGet(Collections::emptyList);
        });
    }

    @Override
    public Optional<IEntityClass> load(String tenantId, String appCode, String boId, String profile) {
        return this.read(() -> {
            String appVersion;
            String boVersion;
            Tuple2<String, UpdateableDataContext> currentVersionDCForBoById = this.versionService.getCurrentVersionDCForBoById(Long.parseLong(boId));
            if (currentVersionDCForBoById != null && !(boVersion = (String)currentVersionDCForBoById._1).equals(appVersion = this.getCurrentModuleVersion())) {
                return Optional.empty();
            }
            UpdateableDataContext dc = Optional.ofNullable(currentVersionDCForBoById).map(Tuple2::_2).orElse(null);
            return Optional.ofNullable(dc).flatMap(x -> this.load(tenantId, appCode, boId, (UpdateableDataContext)x, profile, (String)currentVersionDCForBoById._1()));
        });
    }

    @Override
    public Optional<IEntityClass> load(String tenantId, String appCode, String boId, String profile, String version) {
        return this.read(() -> {
            UpdateableDataContext contextDc = this.versionService.getVersionedDCForBoById(Long.parseLong(boId), version);
            return Optional.ofNullable(contextDc).flatMap(x -> this.load(tenantId, appCode, boId, (UpdateableDataContext)x, profile, version));
        });
    }

    @Override
    public Optional<IEntityClass> loadByCode(String tenantId, String appCode, String boCode, String profile, String version) {
        return this.read(() -> {
            UpdateableDataContext contextDc = this.versionService.getVersionedDCForBoByCode(boCode, version);
            return Optional.ofNullable(contextDc).flatMap(x -> this.loadByCode(tenantId, appCode, boCode, (UpdateableDataContext)x, profile, version));
        });
    }

    public Optional<IEntityClass> loadByCode(String tenantId, String appCode, String boCode, UpdateableDataContext contextDC, String profile, String ver) {
        return this.read(() -> {
            DataSet boDs = ((SatisfiedWhereBuilder)contextDC.query().from("bos").selectAll().where("code").eq(boCode)).execute();
            if (boDs.next()) {
                Optional<IEntityClass> iEntityClass = this.toEntityClass(boDs.getRow(), contextDC, profile, ver);
                return iEntityClass.map(x -> {
                    List<IEntityClass> simpleSubEntities = this.findSimpleSubEntities((IEntityClass)x, tenantId, appCode, Long.toString(x.id()), contextDC, profile, ver);
                    if (simpleSubEntities.isEmpty()) {
                        log.debug("[Meta]Current entity {}:{} has no child", (Object)x.code(), (Object)x.id());
                    }
                    x.resetChildEntityClass(simpleSubEntities);
                    return x;
                });
            }
            return Optional.empty();
        });
    }

    private Optional<IEntityClass> load(String tenantId, String appCode, String boId, UpdateableDataContext contextDC, String profile, String ver) {
        log.debug("load class {} with contextDC {}", (Object)boId, (Object)contextDC);
        return this.read(() -> {
            DataSet boDs = ((SatisfiedWhereBuilder)contextDC.query().from("bos").selectAll().where("id").eq(boId)).execute();
            if (boDs.next()) {
                Optional<IEntityClass> iEntityClass = this.toEntityClass(boDs.getRow(), contextDC, profile, ver);
                return iEntityClass.map(x -> {
                    List<IEntityClass> simpleSubEntities = this.findSimpleSubEntities((IEntityClass)x, tenantId, appCode, boId, contextDC, profile, ver);
                    if (simpleSubEntities.isEmpty()) {
                        log.debug("[Meta]Current entity {}:{} has no child", (Object)x.code(), (Object)x.id());
                    }
                    x.resetChildEntityClass(simpleSubEntities);
                    return x;
                });
            }
            return Optional.empty();
        });
    }

    public List<IEntityClass> findSimpleSubEntities(IEntityClass iEntityClass, String tenantId, String appId, String parentId, UpdateableDataContext contextDC, String profile, String ver) {
        return this.read(() -> {
            DataSet boDs = ((SatisfiedWhereBuilder)contextDC.query().from("bos").selectAll().where("parentId").eq(parentId)).execute();
            List rows = boDs.toRows();
            return rows.stream().map(row -> this.toSimpleEntityClass((Row)row, iEntityClass, contextDC, profile, ver)).collect(Collectors.toList());
        });
    }

    private IEntityClass toSimpleEntityClass(Row row, IEntityClass parent, UpdateableDataContext contextDC, String profile, String ver) {
        return (IEntityClass)this.read(() -> {
            String code = RowUtils.getRowValue(row, "code").map(String::valueOf).orElse("");
            String boId = RowUtils.getRowValue(row, "id").map(String::valueOf).orElse("0");
            String name = RowUtils.getRowValue(row, "name").map(String::valueOf).orElse("");
            List<IEntityField> fields = this.loadFields(boId, profile, contextDC);
            EntityClass entityClass = new EntityClass(Long.valueOf(boId), VersionUtils.toVersionInt(ver).intValue(), code, name, Collections.emptyList(), Collections.emptyList(), parent, fields);
            return entityClass;
        });
    }

    private Optional<IEntityClass> toEntityClass(Row row, UpdateableDataContext contextDC, String profile, String ver) {
        return this.read(() -> {
            String code = RowUtils.getRowValue(row, "code").map(String::valueOf).orElse("");
            String boId = RowUtils.getRowValue(row, "id").map(String::valueOf).orElse("0");
            String name = RowUtils.getRowValue(row, "name").map(String::valueOf).orElse("");
            String type = RowUtils.getRowValue(row, "type").map(String::valueOf).orElse("0");
            List<IEntityField> fields = this.loadFields(boId, profile, contextDC);
            String parentId = RowUtils.getRowValue(row, "parentId").map(String::valueOf).orElse("");
            Optional<IEntityClass> parentEntityClassOp = this.loadParentEntityClassWithRelation(parentId, profile, contextDC, ver);
            LinkedList relationRows = new LinkedList();
            DataSet relDs = ((SatisfiedWhereBuilder)contextDC.query().from("rels").selectAll().where("boId").eq(boId)).execute();
            relationRows.addAll(relDs.toRows());
            LinkedList relsRows = relationRows;
            List<Tuple2> relatedEntityClassList = relsRows.stream().map(relRow -> {
                Optional<String> relatedBoIdOp = RowUtils.getRowValue(relRow, "joinBoId").map(String::valueOf);
                return relatedBoIdOp.flatMap(x -> this.loadRelationEntityClass(boId, (String)x, (Row)relRow, code, contextDC, profile, ver));
            }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            LinkedList entityClassList = new LinkedList();
            LinkedList relationList = new LinkedList();
            LinkedList<IEntityField> allFields = new LinkedList<IEntityField>();
            allFields.addAll(fields);
            relatedEntityClassList.forEach(tuple -> {
                entityClassList.add(tuple._2());
                relationList.add(tuple._1());
            });
            relationList.stream().filter(x -> FieldLikeRelationType.from((String)x.getRelationType()).map(FieldLikeRelationType::isOwnerSide).orElse(false)).forEach(x -> allFields.add(x.getEntityField()));
            EntityClass entityClass = new EntityClass(Long.valueOf(boId), VersionUtils.toVersionInt(ver).intValue(), code, name, relationList, entityClassList, (IEntityClass)parentEntityClassOp.orElse(null), allFields);
            if (!StringUtils.isEmpty((CharSequence)type) && "external".equals(type)) {
                entityClass.setType(1);
            } else {
                entityClass.setType(0);
            }
            return Optional.of(entityClass);
        });
    }

    private <U> List<U> loadRelationField(List<Row> relations, Function<Row, U> mapper) {
        return relations.stream().filter(row -> RowUtils.getRowValue(row, "relType").map(String::valueOf).filter(type -> type.equalsIgnoreCase("onetoone") || type.equalsIgnoreCase("manytoone")).isPresent()).map(mapper).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Table getTable(String tableName, UpdateableDataContext contextDC) {
        return this.read(() -> contextDC.getTableByQualifiedLabel("metadata." + tableName));
    }

    private Optional<Row> findOneById(String tableName, String id, UpdateableDataContext dc) {
        return this.read(() -> {
            DataSet ds = ((SatisfiedWhereBuilder)dc.query().from(tableName).selectAll().where("id").eq(id)).execute();
            if (ds.next()) {
                return Optional.ofNullable(ds.getRow());
            }
            return Optional.empty();
        });
    }

    @Override
    public void clearAllBoIdRelated(String boId, Long moduleId, UpdateableDataContext dc) {
        this.write(() -> {
            UpdateSummary updateSummary = dc.executeUpdate(callback -> {
                ((RowDeletionBuilder)callback.deleteFrom(this.getTable("bos", dc)).where("id").eq(boId)).execute();
                ((RowDeletionBuilder)callback.deleteFrom(this.getTable("apis", dc)).where("boId").eq(boId)).execute();
                ((RowDeletionBuilder)callback.deleteFrom(this.getTable("fields", dc)).where("boId").eq(boId)).execute();
                ((RowDeletionBuilder)callback.deleteFrom(this.getTable("rels", dc)).where("boId").eq(boId)).execute();
            });
            return null;
        });
    }

    @Override
    public SimpleBoItem findOneById(String boId) {
        return this.read(() -> {
            String appVersion;
            String boVersion;
            Tuple2<String, UpdateableDataContext> currentVersionDCForBoById = this.versionService.getCurrentVersionDCForBoById(Long.parseLong(boId));
            if (currentVersionDCForBoById != null && !(boVersion = (String)currentVersionDCForBoById._1).equals(appVersion = this.getCurrentModuleVersion())) {
                return null;
            }
            UpdateableDataContext dc = Optional.ofNullable(currentVersionDCForBoById).map(Tuple2::_2).orElse(null);
            return Optional.ofNullable(dc).map(x -> this.findOneById(boId, dc)).orElse(null);
        });
    }

    @Override
    public SimpleBoItem findOneById(String boId, String version) {
        return this.read(() -> {
            UpdateableDataContext dc = this.versionService.getVersionedDCForBoById(Long.parseLong(boId), version);
            return Optional.ofNullable(dc).map(x -> this.findOneById(boId, dc)).orElse(null);
        });
    }

    public SimpleBoItem findOneById(String boId, UpdateableDataContext contextDC) {
        return this.read(() -> {
            DataSet boDs = ((SatisfiedWhereBuilder)contextDC.query().from("bos").selectAll().where("id").eq(boId)).execute();
            if (boDs.next()) {
                SimpleBoItem simpleBoItem = new SimpleBoItem();
                Row row = boDs.getRow();
                simpleBoItem.setCode(RowUtils.getRowValue(row, "code").map(String::valueOf).orElse(""));
                simpleBoItem.setParentId(RowUtils.getRowValue(row, "parentId").map(String::valueOf).orElse(""));
                simpleBoItem.setId(boId);
                simpleBoItem.setCname(RowUtils.getRowValue(row, "name").map(String::valueOf).orElse(""));
                return simpleBoItem;
            }
            return null;
        });
    }

    @Override
    public List<IEntityClass> findAllEntities(String profile) {
        String appVersion = this.getCurrentModuleVersion();
        return this.read(() -> this.versionService.getBoModuleMapping().entrySet().stream().map(x -> {
            Long boId = ((BoNode)x.getKey()).getId();
            LinkedList value = (LinkedList)x.getValue();
            String version = (String)((Tuple2)value.getLast())._2();
            if (version.equals(appVersion)) {
                UpdateableDataContext versionedDCForBoId = this.versionService.getVersionedDCForBoById(boId, version);
                log.debug("CurrentContext is {}", (Object)versionedDCForBoId);
                return Optional.ofNullable(versionedDCForBoId).flatMap(dc -> this.load("", "", String.valueOf(boId), (UpdateableDataContext)dc, profile, version));
            }
            return Optional.empty();
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
    }

    private List<IEntityClass> findAllEntities(UpdateableDataContext contextDC, String profile, String ver) {
        return this.read(() -> {
            DataSet boDs = contextDC.query().from("bos").selectAll().execute();
            List rows = boDs.toRows();
            return rows.stream().map(x -> this.toEntityClass((Row)x, contextDC, profile, ver)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        });
    }

    @Override
    public CurrentVersion currentVersion() {
        return this.read(() -> new CurrentVersion(this.versionService.getCurrentVersion()));
    }

    private void insertBoTable(String id, String moduleId, String code, String parentId, String name, String rootFlag, String sysType, String domainCode, String domainName, long domainRootId, String type, UpdateableDataContext contextDC) {
        this.write(() -> {
            InsertInto insert = (InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)new InsertInto(this.getTable("bos", contextDC)).value("id", (Object)id)).value("code", (Object)code)).value("parentId", (Object)parentId)).value("name", (Object)name)).value("moduleId", (Object)moduleId)).value("rootFlag", (Object)rootFlag)).value("sysType", (Object)sysType)).value("domainCode", (Object)domainCode)).value("domainName", (Object)domainName)).value("domainRootId", (Object)domainRootId)).value("type", (Object)type);
            contextDC.executeUpdate((UpdateScript)insert);
            return null;
        });
    }

    private void saveApp(AppUp appUp, UpdateableDataContext contextDC) {
        this.write(() -> {
            DeleteFrom deleteFrom = (DeleteFrom)new DeleteFrom(this.getTable("app", contextDC)).where("appId").eq((Number)appUp.getId());
            contextDC.executeUpdate((UpdateScript)deleteFrom);
            InsertInto insert = (InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)new InsertInto(this.getTable("app", contextDC)).value("appId", (Object)appUp.getId())).value("appCode", (Object)appUp.getCode())).value("appName", (Object)appUp.getName())).value("appBranch", (Object)appUp.getBranch())).value("appVersion", (Object)appUp.getVersion());
            contextDC.executeUpdate((UpdateScript)insert);
            return null;
        });
    }

    private void insertBo(long moduleId, BoUp boUp, UpdateableDataContext contextDC) {
        this.write(() -> {
            this.insertBoTable(boUp.getId(), String.valueOf(moduleId), boUp.getCode(), boUp.getParentBoId(), boUp.getName(), boUp.getRootFlag(), boUp.getSysType(), boUp.getDomainCode(), boUp.getDomainName(), boUp.getDomainRootId(), boUp.getBoType(), contextDC);
            boUp.getRelationsList().forEach(rel -> {
                InsertInto insertRel = (InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)new InsertInto(this.getTable("rels", contextDC)).value("id", (Object)rel.getId())).value("boId", (Object)rel.getBoId())).value("joinBoId", (Object)rel.getJoinBoId())).value("identity", (Object)rel.getIdentity())).value("relType", (Object)rel.getRelationType())).value("relName", (Object)rel.getRelName())).value("boField", (Object)rel.getBoField())).value("joinField", (Object)rel.getJoinField())).value("profile", (Object)rel.getProfile());
                contextDC.executeUpdate((UpdateScript)insertRel);
            });
            boUp.getApisList().forEach(api -> this.insertApi((Api)api, boUp.getId(), contextDC));
            boUp.getFieldsList().forEach(field -> this.insertField((Field)field, boUp.getId(), contextDC));
            boUp.getBoUpsList().stream().filter(relatedBo -> !this.findOneById("bos", relatedBo.getId(), contextDC).isPresent()).forEach(relatedBo -> {
                this.insertBoTable(relatedBo.getId(), String.valueOf(moduleId), relatedBo.getCode(), relatedBo.getParentBoId(), relatedBo.getName(), relatedBo.getRootFlag(), relatedBo.getSysType(), relatedBo.getDomainCode(), relatedBo.getDomainName(), relatedBo.getDomainRootId(), relatedBo.getBoType(), contextDC);
                relatedBo.getApisList().forEach(api -> this.insertApi((Api)api, relatedBo.getId(), contextDC));
                relatedBo.getFieldsList().forEach(field -> this.insertField((Field)field, relatedBo.getId(), contextDC));
            });
            return null;
        });
    }

    private String getBooleanString(String input) {
        if ("1".equals(input) || "true".equals(input)) {
            return "true";
        }
        return "false";
    }

    private void insertField(Field field, String boId, UpdateableDataContext contextDC) {
        this.write(() -> {
            String editable = this.getBooleanString(field.getEditable());
            String searchable = this.getBooleanString(field.getSearchable());
            String identifier = this.getBooleanString(field.getIdentifier());
            String required = this.getBooleanString(field.getRequired());
            boolean hasFormula = field.hasCalculator();
            InsertInto insert = (InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)new InsertInto(this.getTable("fields", contextDC)).value("boId", (Object)boId)).value("id", (Object)field.getId())).value("code", (Object)field.getCode())).value("displayType", (Object)field.getDisplayType())).value("editable", (Object)editable)).value("enumCode", (Object)field.getEnumCode())).value("maxLength", (Object)field.getMaxLength())).value("name", (Object)field.getName())).value("required", (Object)required)).value("fieldType", (Object)field.getFieldType())).value("searchable", (Object)searchable)).value("dictId", (Object)field.getDictId())).value("defaultValue", (Object)field.getDefaultValue())).value("precision", (Object)String.valueOf(field.getPrecision()))).value("identifier", (Object)identifier)).value("validateRule", (Object)field.getValidateRule())).value("uniqueName", (Object)field.getUniqueName())).value("indexFlag", (Object)field.getIndexFlag())).value("dimensionFlag", (Object)field.getDimensionFlag())).value("profile", (Object)field.getProfile())).value("calculateType", (Object)field.getCalculator().getCalculateType())).value("formulaBody", (Object)(hasFormula ? field.getCalculator().getExpression() : ""))).value("formulaArguments", (Object)(hasFormula ? field.getCalculator().getArgumentsList().stream().collect(Collectors.joining(",")) : ""));
            contextDC.executeUpdate((UpdateScript)insert);
            return null;
        });
    }

    private void insertApi(Api api, String boId, UpdateableDataContext dc) {
        this.write(() -> {
            HashMap config = new HashMap();
            List rules = api.getDetailsList().stream().map(x -> {
                HashMap<String, Object> rule = new HashMap<String, Object>();
                rule.put("expression", x.getRule());
                rule.put("type", x.getType());
                return rule;
            }).collect(Collectors.toList());
            config.put("rules", rules);
            String configJson = "{}";
            try {
                configJson = this.mapper.writeValueAsString(config);
            }
            catch (Exception ex) {
                log.error("{}", (Throwable)ex);
            }
            InsertInto insert = (InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)new InsertInto(this.getTable("apis", dc)).value("boId", (Object)boId)).value("url", (Object)api.getUrl())).value("externalUrl", (Object)api.getExternalUrl())).value("code", (Object)api.getCode())).value("method", (Object)api.getMethod())).value("param", (Object)api.getParam())).value("responseData", (Object)api.getResponseData())).value("responseHeader", (Object)api.getRequestHeader())).value("authCode", (Object)api.getAuthCode())).value("config", (Object)configJson)).value("profile", (Object)api.getProfile());
            dc.executeUpdate((UpdateScript)insert);
            return null;
        });
    }

    private List<IEntityField> loadFields(String id, String profile, UpdateableDataContext dc) {
        return this.read(() -> {
            DataSet fieldDs = ((SatisfiedWhereBuilder)((SatisfiedWhereBuilder)dc.query().from("fields").selectAll().where("boId").eq(id)).and("profile").in(new String[]{profile, ""})).execute();
            return fieldDs.toRows().stream().map(FieldHelper::toEntityClassField).collect(Collectors.toList());
        });
    }

    @Override
    public List<BoInfoVo> loadSonBoInfoVo(String code, String profile) {
        return this.read(() -> {
            Tuple2<String, UpdateableDataContext> currentVersionDCForBoByCode = this.versionService.getCurrentVersionDCForBoByCode(code);
            UpdateableDataContext dc = Optional.ofNullable(currentVersionDCForBoByCode).map(Tuple2::_2).orElse(null);
            return this.loadSonBoInfoByCode(code, dc);
        });
    }

    @Override
    public List<BoInfoVo> getAllBoInfo(String profile) {
        return this.read(() -> this.versionService.getBoModuleMapping().entrySet().stream().map(x -> {
            Long boId = ((BoNode)x.getKey()).getId();
            LinkedList value = (LinkedList)x.getValue();
            String version = (String)((Tuple2)value.getLast())._2();
            UpdateableDataContext versionedDCForBoId = this.versionService.getVersionedDCForBoById(boId, version);
            log.debug("CurrentContext is {}", (Object)versionedDCForBoId);
            return Optional.ofNullable(versionedDCForBoId).flatMap(dc -> this.loadBoInfo(String.valueOf(boId), (UpdateableDataContext)dc));
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
    }

    @Override
    public BoInfoVo getBoInfo(String code, String profile) {
        return this.read(() -> {
            Tuple2<String, UpdateableDataContext> currentVersionDCForBoByCode = this.versionService.getCurrentVersionDCForBoByCode(code);
            UpdateableDataContext dc = Optional.ofNullable(currentVersionDCForBoByCode).map(Tuple2::_2).orElse(null);
            return this.loadBoInfoByCode(code, dc).orElse(null);
        });
    }

    private String getCurrentModuleVersion() {
        Map<Long, String> currentVersion = this.versionService.getCurrentVersion();
        Collection<String> values = currentVersion.values();
        if (!values.isEmpty()) {
            return values.stream().findFirst().orElse(null);
        }
        return null;
    }

    @Override
    public AppItem getCurrentApp() {
        DataSet rows = this.versionService.getGlobalDC().query().from("app").selectAll().limit(1).execute();
        AppItem appItem = null;
        List resultRow = rows.toRows();
        if (!resultRow.isEmpty()) {
            Row row = (Row)resultRow.get(0);
            appItem = new AppItem();
            String appCode = RowUtils.getRowValue(row, "appCode").map(String::valueOf).orElse("");
            String appVersion = RowUtils.getRowValue(row, "appVersion").map(String::valueOf).orElse("");
            String appBranch = RowUtils.getRowValue(row, "appBranch").map(String::valueOf).orElse("");
            appItem.setAppCode(appCode);
            appItem.setAppVersion(appVersion);
            appItem.setAppBranch(appBranch);
            return appItem;
        }
        return null;
    }

    @Override
    public List<BoInfoVo> loadRelatedBoInfoVo(String code, String profile) {
        return this.read(() -> {
            Tuple2<String, UpdateableDataContext> currentVersionDCForBoByCode = this.versionService.getCurrentVersionDCForBoByCode(code);
            UpdateableDataContext dc = Optional.ofNullable(currentVersionDCForBoByCode).map(Tuple2::_2).orElse(null);
            HashSet<Long> circleDetected = new HashSet<Long>();
            LinkedList<BoInfoVo> relatedBoList = new LinkedList<BoInfoVo>();
            this.loadRelatedBoInfoVoByCode(code, dc, circleDetected, relatedBoList);
            return relatedBoList;
        });
    }

    @Override
    public ApiDetails loadApiByCodeAndEntityClass(String actionCode, long boId) {
        return this.read(() -> {
            Tuple2<String, UpdateableDataContext> currentVersionDCForBoById = this.versionService.getCurrentVersionDCForBoById(boId);
            UpdateableDataContext dc = Optional.ofNullable(currentVersionDCForBoById).map(Tuple2::_2).orElse(null);
            DataSet dataSet = ((SatisfiedWhereBuilder)((SatisfiedWhereBuilder)dc.query().from("apis").selectAll().where("boId").eq((Number)boId)).and("code").eq(actionCode)).execute();
            List rows = dataSet.toRows();
            if (!rows.isEmpty()) {
                Row row = (Row)rows.get(0);
                Optional<String> configJson = RowUtils.getRowValue(row, "config").map(Object::toString);
                Optional<String> fixedHeaderJson = RowUtils.getRowValue(row, "responseHeader").map(Object::toString);
                Optional<String> authCode = RowUtils.getRowValue(row, "authCode").map(Object::toString);
                Optional<String> method = RowUtils.getRowValue(row, "method").map(Object::toString);
                Optional<String> externalUrl = RowUtils.getRowValue(row, "externalUrl").map(Object::toString);
                Optional<String> url = RowUtils.getRowValue(row, "url").map(Object::toString);
                url.orElseThrow(() -> new RuntimeException("URL is required " + actionCode));
                String value = configJson.orElse("{}");
                Map configMap = Collections.emptyMap();
                try {
                    configMap = (Map)this.mapper.readValue(value, (TypeReference)new TypeReference<Map<String, Object>>(){});
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String fixedHeader = fixedHeaderJson.orElse("[]");
                List headerMap = Collections.emptyList();
                try {
                    headerMap = (List)this.mapper.readValue(fixedHeader, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                ApiDetails apiDetails = new ApiDetails();
                apiDetails.setAuthCode(authCode.orElse(""));
                apiDetails.setCode(actionCode);
                apiDetails.setMethod(method.orElse("GET"));
                apiDetails.setExternalUrl(externalUrl.orElse(""));
                apiDetails.setUrl(url.orElse(""));
                apiDetails.setFixedHeaders(headerMap);
                Object rules = configMap.get("rules");
                if (rules != null) {
                    List typedRules = (List)rules;
                    List apiRules = typedRules.stream().map(tr -> {
                        Object expression = tr.get("expression");
                        Object type = tr.get("type");
                        if (expression != null && type != null) {
                            ApiRule apiRule = new ApiRule();
                            apiRule.setType(type.toString());
                            apiRule.setExpression(expression.toString());
                            return apiRule;
                        }
                        return null;
                    }).filter(Objects::nonNull).collect(Collectors.toList());
                    apiDetails.setRules(apiRules);
                }
                return apiDetails;
            }
            return null;
        });
    }

    @Override
    public Set<String> findCustomActionsById(Long id) {
        return this.read(() -> {
            Tuple2<String, UpdateableDataContext> currentVersionDCForBoByCode = this.versionService.getCurrentVersionDCForBoById(id);
            UpdateableDataContext dc = Optional.ofNullable(currentVersionDCForBoByCode).map(Tuple2::_2).orElse(null);
            DataSet row = ((SatisfiedWhereBuilder)dc.query().from("apis").select("code").where("boId").eq((Number)id)).execute();
            return row.toRows().stream().map(x -> RowUtils.getRowValue(x, "code")).filter(Optional::isPresent).map(Optional::get).map(Object::toString).filter(x -> Arrays.stream(preserved).noneMatch(y -> y.equals(x))).collect(Collectors.toSet());
        });
    }

    private void loadNested(BoInfoVo mainBo, UpdateableDataContext dc, Set<Long> circleDetected, List<BoInfoVo> relatedBoList) {
        if (circleDetected.contains(mainBo.getId())) {
            return;
        }
        circleDetected.add(mainBo.getId());
        relatedBoList.add(mainBo);
        List relationshipVos = mainBo.getRelationshipVos();
        if (relationshipVos != null && !relationshipVos.isEmpty()) {
            Set relationCodes = relationshipVos.stream().map(RelationshipVo::getBoId).collect(Collectors.toSet());
            Sets.SetView intersection = Sets.intersection(circleDetected, relationCodes);
            for (Long boId : intersection) {
                this.loadRelatedBoInfoVoById(boId, dc, circleDetected, relatedBoList);
            }
        }
    }

    private void loadRelatedBoInfoVoById(Long id, UpdateableDataContext dc, Set<Long> circleDetected, List<BoInfoVo> relatedBoList) {
        this.read(() -> {
            Optional<BoInfoVo> boInfoVo = this.loadBoInfo(id.toString(), dc);
            if (boInfoVo.isPresent()) {
                relatedBoList.add(boInfoVo.get());
                this.loadNested(boInfoVo.get(), dc, circleDetected, relatedBoList);
            }
            return null;
        });
    }

    private void loadRelatedBoInfoVoByCode(String code, UpdateableDataContext dc, Set<Long> circleDetected, List<BoInfoVo> relatedBoList) {
        this.read(() -> {
            Optional<BoInfoVo> boInfoVo = this.loadBoInfoByCode(code, dc);
            if (boInfoVo.isPresent()) {
                relatedBoList.add(boInfoVo.get());
                this.loadNested(boInfoVo.get(), dc, circleDetected, relatedBoList);
            }
            return null;
        });
    }

    private List<BoInfoVo> loadSonBoInfoByCode(String code, UpdateableDataContext contextDC) {
        return this.read(() -> {
            Row row;
            Optional<Object> rowValue;
            DataSet boDs = ((SatisfiedWhereBuilder)contextDC.query().from("bos").selectAll().where("code").eq(code)).execute();
            List rows = boDs.toRows();
            if (!rows.isEmpty() && (rowValue = RowUtils.getRowValue(row = (Row)rows.get(0), "id")).isPresent()) {
                String boId = rowValue.get().toString();
                DataSet sonBoDs = ((SatisfiedWhereBuilder)contextDC.query().from("bos").selectAll().where("parentId").eq(boId)).execute();
                List sonRow = sonBoDs.toRows();
                return sonRow.stream().map(x -> this.toBoInfo((Row)x, contextDC)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            }
            return Collections.emptyList();
        });
    }

    private Optional<BoInfoVo> loadBoInfoByCode(String code, UpdateableDataContext contextDC) {
        return this.read(() -> {
            DataSet boDs = ((SatisfiedWhereBuilder)contextDC.query().from("bos").selectAll().where("code").eq(code)).execute();
            if (boDs.next()) {
                return this.toBoInfo(boDs.getRow(), contextDC);
            }
            return Optional.empty();
        });
    }

    private Optional<BoInfoVo> loadBoInfo(String boId, UpdateableDataContext contextDC) {
        return this.read(() -> {
            DataSet boDs = ((SatisfiedWhereBuilder)contextDC.query().from("bos").selectAll().where("id").eq(boId)).execute();
            if (boDs.next()) {
                return this.toBoInfo(boDs.getRow(), contextDC);
            }
            return Optional.empty();
        });
    }

    private Optional<BoInfoVo> toBoInfo(Row row, UpdateableDataContext contextDC) {
        return this.read(() -> {
            Optional<BoInfoVo> boInfoVo;
            String code = RowUtils.getRowValue(row, "code").map(String::valueOf).orElse("");
            String boId = RowUtils.getRowValue(row, "id").map(String::valueOf).orElse("0");
            String name = RowUtils.getRowValue(row, "name").map(String::valueOf).orElse("");
            String parentId = RowUtils.getRowValue(row, "parentId").map(String::valueOf).orElse("");
            List parentFields = Collections.emptyList();
            List parentRelationshipVos = Collections.emptyList();
            if (StringUtils.isNotEmpty((CharSequence)parentId) && (boInfoVo = this.loadBoInfo(parentId, contextDC)).isPresent()) {
                BoInfoVo parentBoInfoVo = boInfoVo.get();
                parentFields = parentBoInfoVo.getFields();
                parentRelationshipVos = parentBoInfoVo.getRelationshipVos();
            }
            String sysType = RowUtils.getRowValue(row, "sysType").map(String::valueOf).orElse("");
            String domainName = RowUtils.getRowValue(row, "domainName").map(String::valueOf).orElse("");
            String domainCode = RowUtils.getRowValue(row, "domainCode").map(String::valueOf).orElse("");
            String domainRootId = RowUtils.getRowValue(row, "domainRootId").map(String::valueOf).orElse("");
            String rootFlag = RowUtils.getRowValue(row, "rootFlag").map(String::valueOf).orElse("");
            BoInfoVo boInfoVo2 = new BoInfoVo();
            boInfoVo2.setApis(this.loadApis(boId, contextDC));
            LinkedList relationRows = new LinkedList();
            DataSet relDs = ((SatisfiedWhereBuilder)contextDC.query().from("rels").selectAll().where("boId").eq(boId)).execute();
            relationRows.addAll(relDs.toRows());
            LinkedList relsRows = relationRows;
            List relations = relsRows.stream().map(x -> this.toRelationVo(boId, (Row)x)).collect(Collectors.toList());
            List relatedFields = relations.stream().filter(x -> x.getRelationType().equalsIgnoreCase(FieldLikeRelationType.MANY2ONE.getName()) || x.getRelationType().equalsIgnoreCase(FieldLikeRelationType.ONE2ONE.getName()) || x.getRelationType().equalsIgnoreCase(FieldLikeRelationType.MULTI_VALUES.getName())).map(x -> {
                BoFieldVo boFieldVo = new BoFieldVo();
                boFieldVo.setId(x.getId());
                boFieldVo.setCode(x.getRelationCode().concat(".id"));
                boFieldVo.setSearchable(Boolean.valueOf(true));
                if (x.getRelationType().equalsIgnoreCase(FieldLikeRelationType.MULTI_VALUES.getName())) {
                    boFieldVo.setType(FieldType.STRINGS.getType());
                } else {
                    boFieldVo.setType(FieldType.LONG.getType());
                }
                return boFieldVo;
            }).collect(Collectors.toList());
            if (!parentRelationshipVos.isEmpty()) {
                ArrayList vos = new ArrayList(parentRelationshipVos);
                vos.addAll(relations);
                relations = vos;
            }
            boInfoVo2.setRelationshipVos(relations);
            ArrayList fields = new ArrayList(relatedFields);
            List<BoFieldVo> currentFields = this.loadBoFields(boId, contextDC);
            fields.addAll(currentFields);
            if (!parentFields.isEmpty()) {
                fields.addAll(parentFields);
            }
            boInfoVo2.setFields(fields);
            boInfoVo2.setSysType(sysType);
            boInfoVo2.setCode(code);
            boInfoVo2.setId(Long.valueOf(Long.parseLong(boId)));
            boInfoVo2.setName(name);
            boInfoVo2.setDomainCode(domainCode);
            boInfoVo2.setDomainName(domainName);
            boInfoVo2.setRootFlag(rootFlag);
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{parentId})) {
                boInfoVo2.setParentBoId(Long.valueOf(Long.parseLong(parentId)));
            }
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{domainRootId})) {
                boInfoVo2.setDomainRootId(Long.valueOf(Long.parseLong(domainRootId)));
            }
            return Optional.of(boInfoVo2);
        });
    }

    private List<BoApiVo> loadApis(String boId, UpdateableDataContext dc) {
        return this.read(() -> {
            DataSet apis = ((SatisfiedWhereBuilder)dc.query().from("apis").selectAll().where("boId").eq(boId)).execute();
            return this.toBoApiVo(boId, apis);
        });
    }

    private List<BoFieldVo> loadBoFields(String boId, UpdateableDataContext dc) {
        return this.read(() -> {
            DataSet fieldDs = ((SatisfiedWhereBuilder)dc.query().from("fields").selectAll().where("boId").eq(boId)).execute();
            return fieldDs.toRows().stream().map(x -> FieldHelper.toBoFieldVo(boId, x)).collect(Collectors.toList());
        });
    }

    private List<BoApiVo> toBoApiVo(String boId, DataSet apis) {
        LinkedList<BoApiVo> boApiVos = new LinkedList<BoApiVo>();
        while (apis.next()) {
            Row row = apis.getRow();
            String code = RowUtils.getRowValue(row, "code").map(String::valueOf).orElse("");
            String url = RowUtils.getRowValue(row, "url").map(String::valueOf).orElse("");
            String externalUrl = RowUtils.getRowValue(row, "externalUrl").map(String::valueOf).orElse("");
            String method = RowUtils.getRowValue(row, "method").map(String::valueOf).orElse("");
            String param = RowUtils.getRowValue(row, "param").map(String::valueOf).orElse("");
            String responseData = RowUtils.getRowValue(row, "responseData").map(String::valueOf).orElse("");
            BoApiVo apiItem = new BoApiVo();
            apiItem.setBoId(Long.valueOf(Long.parseLong(boId)));
            apiItem.setCode(code);
            apiItem.setUrl(url);
            apiItem.setMethod(method);
            apiItem.setParam(param);
            apiItem.setResponseData(responseData);
            boApiVos.add(apiItem);
        }
        return boApiVos;
    }

    private RelationshipVo toRelationVo(String boId, Row row) {
        String id = RowUtils.getRowValue(row, "id").map(String::valueOf).orElse("0");
        String boField = RowUtils.getRowValue(row, "boField").map(String::valueOf).orElse("");
        String joinField = RowUtils.getRowValue(row, "joinField").map(String::valueOf).orElse("");
        String joinBoID = RowUtils.getRowValue(row, "joinBoId").map(String::valueOf).orElse("");
        String code = RowUtils.getRowValue(row, "relName").map(String::valueOf).orElse("");
        String type = RowUtils.getRowValue(row, "relType").map(String::valueOf).orElse("");
        RelationshipVo relationshipVo = new RelationshipVo();
        relationshipVo.setBoId(Long.valueOf(Long.parseLong(boId)));
        relationshipVo.setId(Long.valueOf(Long.parseLong(id)));
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{boField})) {
            relationshipVo.setBoField(Long.valueOf(Long.parseLong(boField)));
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{joinField})) {
            relationshipVo.setJoinField(Long.valueOf(Long.parseLong(joinField)));
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{joinBoID})) {
            relationshipVo.setJoinBoId(Long.valueOf(Long.parseLong(joinBoID)));
        }
        relationshipVo.setRelationCode(code);
        relationshipVo.setRelationType(type);
        return relationshipVo;
    }
}

