package com.xforceplus.ultraman.metadata.sync.grpc.store.impl.tables;

import com.xforceplus.ultraman.metadata.sync.grpc.store.TableLike;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * TODO API rule table
 */
public class ApiRuleTable implements TableLike {

    public static final String TABLE_NAME = "api-rule";

    /**
     *
     */
    public static final String BO_ID = "boId";

    /**
     * type request or response rule
     */
    public static final String TYPE = "type";

    /**
     * header
     * param
     * body
     */
    public static final String SCOPE = "scope";

    /**
     * rule id
     */
    public static final String ID = "id";

    /**
     * related api
     */
    public static final String API_ID = "apiId";

    /**
     * converter expression
     */
    public static final String EXPR = "expression";

    public static final String PROFILE = "profile";

    private List<Map<String, ?>> store = new ArrayList<>();

    public static final String[] columns = new String[]{BO_ID, ID, SCOPE, API_ID
            , EXPR, PROFILE, TYPE};

    @Override
    public String name() {
        return TABLE_NAME;
    }

    @Override
    public String[] columns() {
        return columns;
    }

    @Override
    public List<Map<String, ?>> getStore() {
        return store;
    }

}
