package com.xforceplus.ultraman.metadata.sync.grpc.store.utils;

import com.xforceplus.tech.common.utils.OptionalHelper;
import com.xforceplus.ultraman.metadata.constants.SystemField;
import com.xforceplus.ultraman.metadata.domain.vo.dto.BoFieldVo;
import com.xforceplus.ultraman.metadata.entity.FieldConfig;
import com.xforceplus.ultraman.metadata.entity.FieldType;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.entity.legacy.impl.EntityField;
import com.xforceplus.ultraman.metadata.entity.legacy.impl.Formula;
import com.xforceplus.ultraman.metadata.sync.grpc.store.impl.tables.FieldTable;
import org.apache.commons.lang3.StringUtils;
import org.apache.metamodel.data.Row;

import java.util.Arrays;
import java.util.stream.Stream;

/**
 *
 * helper to handler several object
 */
public class FieldHelper {


    public static BoFieldVo toBoFieldVo(String boId, Row row) {
        BoFieldVo boFieldVo = new BoFieldVo();

        Long id = 0L;
        try {
            id = RowUtils.getRowValue(row, "id")
                    .map(String::valueOf)
                    .map(Long::valueOf)
                    .orElse(-1L);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        String code = RowUtils.getRowValue(row, FieldTable.CODE).map(String::valueOf).orElse("");

        String name = RowUtils.getRowValue(row, FieldTable.NAME).map(String::valueOf).orElse("");


        FieldType fieldType = RowUtils.getRowValue(row, "fieldType")
                .map(String::valueOf)
                .map(FieldType::fromRawType)
                .orElse(FieldType.STRING);

        Boolean searchable = RowUtils.getRowValue(row, "searchable")
                .map(String::valueOf)
                .map(Boolean::valueOf).orElse(false);

        Boolean identifier = RowUtils.getRowValue(row, "identifier")
                .map(String::valueOf)
                .map(Boolean::valueOf).orElse(false);

        Boolean required = RowUtils.getRowValue(row, "required")
                .map(String::valueOf)
                .map(Boolean::valueOf).orElse(false);

        Long max = RowUtils.getRowValue(row, "maxLength")
                .flatMap(OptionalHelper::ofEmptyStr)
                .map(Long::valueOf).orElse(-1L);

        Integer precision = RowUtils.getRowValue(row, "precision")
                .flatMap(OptionalHelper::ofEmptyStr)
                .map(Integer::valueOf).orElse(0);

        String defaultValue = RowUtils.getRowValue(row, "defaultValue")
                .map(String::valueOf).orElse("");

        String dictId = RowUtils.getRowValue(row, "dictId")
                .map(String::valueOf).orElse("");

        String validateRule = RowUtils.getRowValue(row, "validateRule")
                .map(String::valueOf).orElse("");


        String displayType = RowUtils.getRowValue(row, FieldTable.DISPLAY_TYPE)
                .map(String::valueOf).orElse("");

        String dimensionFlag = RowUtils.getRowValue(row, FieldTable.DIMENSION_FlAG)
                .map(String::valueOf).orElse("");

        String indexFlag = RowUtils.getRowValue(row, FieldTable.INDEX_FLAG)
                .map(String::valueOf).orElse("");


        boFieldVo.setBoId(Long.parseLong(boId));
        boFieldVo.setName(name);
        boFieldVo.setCode(code);
        boFieldVo.setDefaultValue(defaultValue);
        boFieldVo.setDecimalPoint(precision.toString());
        boFieldVo.setDimensionFlag(dimensionFlag);
        boFieldVo.setId(id);
        boFieldVo.setRequired(required);
        boFieldVo.setMaxLength(max.toString());
        boFieldVo.setIndexFlag(indexFlag);
        boFieldVo.setSearchable(searchable);
        boFieldVo.setType(fieldType.getType());
        boFieldVo.setValidateRule(validateRule);
        if (StringUtils.isNoneEmpty(dictId)) {
            boFieldVo.setEnumId(Long.parseLong(dictId));
        }

        boFieldVo.setDescribeType(displayType);
        return boFieldVo;
    }


    /**
     * TODO pipeline it
     * Row => field
     *
     * @param row
     * @return
     */
    public static IEntityField toEntityClassField(Row row) {
        Long id = 0L;
        try {
            id = RowUtils.getRowValue(row, SystemField.ID.getName())
                    .map(String::valueOf)
                    .map(Long::valueOf)
                    .orElse(-1L);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        String name = RowUtils.getRowValue(row, FieldTable.CODE).map(String::valueOf).orElse("");
        FieldType fieldType = RowUtils.getRowValue(row, FieldTable.FIELD_TYPE)
                .map(String::valueOf)
                .map(FieldType::fromRawType)
                .orElse(FieldType.STRING);

        boolean isSystem = Stream.of(SystemField.values()).anyMatch(x -> name.equals(x.getName()));

        Boolean searchable = RowUtils.getRowValue(row, FieldTable.SEARCHABLE)
                .map(String::valueOf)
                .map(Boolean::valueOf).orElse(false);

        Boolean identifier = RowUtils.getRowValue(row, FieldTable.IDENTIFIER)
                .map(String::valueOf)
                .map(Boolean::valueOf).orElse(false);

        Boolean required = RowUtils.getRowValue(row, FieldTable.REQUIRED)
                .map(String::valueOf)
                .map(Boolean::valueOf).orElse(false);

        Long max = RowUtils.getRowValue(row, FieldTable.MAX_LENGTH)
                .flatMap(OptionalHelper::ofEmptyStr)
                .map(Long::valueOf).orElse(-1L);

        Integer precision = RowUtils.getRowValue(row, FieldTable.PRECISION)
                .flatMap(OptionalHelper::ofEmptyStr)
                .map(Integer::valueOf).orElse(0);

        String defaultValue = RowUtils.getRowValue(row, FieldTable.DEFAULT_VALUE)
                .map(String::valueOf).orElse(null);

        String dictId = RowUtils.getRowValue(row, FieldTable.DICT_ID)
                .map(String::valueOf).orElse("");

        String validateRule = RowUtils.getRowValue(row, FieldTable.VALIDATE_RULE)
                .map(String::valueOf).orElse("");

        String uniqueName = RowUtils.getRowValue(row, FieldTable.UNIQUE_NAME)
                .map(String::valueOf).orElse("");


        String displayType = RowUtils.getRowValue(row, FieldTable.DISPLAY_TYPE)
                .map(String::valueOf).orElse("");

        String formulaBody = RowUtils.getRowValue(row, FieldTable.FORMULA)
                .map(String::valueOf).orElse("");

        String formulaArgs = RowUtils.getRowValue(row, FieldTable.FORMULA_ARGS)
                .map(String::valueOf).orElse("");

        /**
         * 1 is normal
         */
        Integer calculateType = RowUtils.getRowValue(row, FieldTable.CALCULATE_TYPE)
                .map(String::valueOf).map(Integer::valueOf).orElse(1);

        Formula formula = new Formula();

        if(calculateType > 1){
            formula.setArguments(Arrays.asList(formulaArgs.split(",")));
            formula.setFormulaBody(formulaBody);
        }

        FieldConfig fieldConfig = FieldConfig
                .build()
                .searchable(searchable)
                .max(max)
                .required(required)
                .precision(precision)
                .identifie(identifier)
                .displayType(displayType)
                .validateRegexString(validateRule)
                .uniqueName(uniqueName)
                .formula(formula)
                .calculateType(calculateType)
                .isSystem(isSystem);

        String cnName = RowUtils.getRowValue(row, FieldTable.NAME).map(String::valueOf).orElse("");

        return new EntityField(id, name, cnName, fieldType, fieldConfig, dictId, defaultValue);
    }

//    public static IEntityField toEntityClassFieldFromRel(Row row, String boCode) {
//        Long id = RowUtils.getRowValue(row, FieldTable.ID)
//                .map(String::valueOf)
//                .map(Long::valueOf)
//                .orElse(-1L);
//
//        //TODO current is id
//        //fixed
//        String name = boCode.concat(".id");
//        FieldType fieldType = FieldType.LONG;
//
//        FieldConfig fieldConfig = FieldConfig
//                .build()
//                .searchable(true);
//        return new EntityField(id, name, fieldType, fieldConfig);
//    }
}
