package com.xforceplus.ultraman.metadata.sync.grpc.utils;

import com.xforceplus.metadata.schema.rels.MetadataRelationType;
import com.xforceplus.metadata.schema.typed.*;
import com.xforceplus.metadata.schema.typed.endpoint.BoHttpEndpoint;
import com.xforceplus.ultraman.metadata.grpc.*;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * convert helper
 */
public class DomainConverter {

    public static AppNode toAppNode(ModuleUpResult moduleUpResult) {
        AppUp appUp = moduleUpResult.getAppUp();
        List<BoUp> boUpsList = moduleUpResult.getBoUpsList();
        AppNode appNode = new AppNode();
        appNode.setCode(appUp.getCode());
        appNode.setBranchCode(appUp.getBranch());
        appNode.setVersion(appUp.getVersion());
        appNode.setId(Long.toString(appUp.getId()));
        appNode.setName(appUp.getName());
        List<BoNode> boList = boUpsList.stream().map(x -> {
            return toBoNode(x);
        }).collect(Collectors.toList());
        appNode.setBoNodes(boList);
        return appNode;
    }

    public static BoNode toBoNode(BoUp boUp){
        BoNode boNode = new BoNode();
        boNode.setCode(boUp.getCode());
        boNode.setId(boUp.getId());
        boNode.setName(boUp.getName());
        boNode.setParentId(boUp.getParentBoId());
        boNode.setBoType(boUp.getBoType());
        List<BoField> fields = boUp.getFieldsList().stream()
                .map(DomainConverter::toBoField)
                .collect(Collectors.toList());
        boNode.setFields(fields);

//        List<BoHttpEndpoint> apis = boUp.getApisList().stream()
//                .map(api -> toApi(api, boNode.getId()))
//                .collect(Collectors.toList());
//        boNode.setApis(apis);

        List<BoRelationship> relations = boUp.getRelationsList().stream()
                .map(DomainConverter::toBoRelation)
                .collect(Collectors.toList());

        boNode.setRelationships(relations);
        return boNode;
    }

    public static BoRelationship toBoRelation(Relation rel){
        BoRelationship boRelationship = new BoRelationship();
        if("OneToMany".equals(rel.getRelationType())) {
            boRelationship.setRelationType(MetadataRelationType.TO_MANY.name());
        } else if ("ManyToOne".equals(rel.getRelationType())) {
            boRelationship.setRelationType(MetadataRelationType.TO_ONE.name());
        }
        //TODO other type

        boRelationship.setId(rel.getId());
        boRelationship.setRelationCode(rel.getRelName());
        boRelationship.setRelationName(rel.getRelName());
        boRelationship.setBoId(rel.getBoId());
        boRelationship.setJoinBoId(rel.getJoinBoId());
        boRelationship.setBoFieldId(Optional
                .of(rel.getBoField())
                .map(x -> Long.toString(x))
                .orElse(null));
        boRelationship.setJoinBoFieldId(Optional
                .of(rel.getJoinField())
                .map(x -> Long.toString(x))
                .orElse(null));
        return boRelationship;
    }

    public static BoField toBoField(Field fieldUp){
        BoField boField = new BoField();
        boField.setName(fieldUp.getName());
        boField.setCode(fieldUp.getCode());
        boField.setId(fieldUp.getId());
        //TODO
        FieldType fieldType = new FieldType();
        fieldType.setValueType(fieldUp.getFieldType());
        fieldType.setDictId(fieldUp.getDictId());
        boField.setFieldType(fieldType);
        return boField;
    }
}
