package com.xforceplus.ultraman.metadata.sync.grpc.store.impl.tables;

import com.xforceplus.ultraman.metadata.sync.grpc.store.TableLike;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * SimpleTableDef ApiTableDef'
 * new SimpleTableDef("apis", new String[]{"boId", "url", "method", "code"});
 */
public class ApiTable implements TableLike {

    public static final String TABLE_NAME = "apis";

    public static final String BO_ID = "boId";

    public static final String URL = "url";

    public static final String EXTERNAL_URL = "externalUrl";

    public static final String METHOD = "method";

    public static final String CODE = "code";

    public static final String PARAM = "param";

    public static final String RESPONSE_DATA = "responseData";

    public static final String RESPONSE_HEADER = "responseHeader";

    public static final String PROFILE = "profile";

    /**
     * is external
     */
    public static final String TYPE = "type";

    /**
     * external config json config
     * -- remote return
     */
    public static final String CONFIG = "config";

    public static final String AUTH_CODE = "authCode";

    private List<Map<String, ?>> store = new ArrayList<>();

    public static final String[] columns = new String[]{ BO_ID, URL, EXTERNAL_URL, METHOD
            , CODE, PARAM, RESPONSE_DATA, RESPONSE_HEADER, PROFILE, TYPE, CONFIG, AUTH_CODE };

    @Override
    public String name() {
        return TABLE_NAME;
    }

    @Override
    public String[] columns() {
        return columns;
    }

    @Override
    public List<Map<String, ?>> getStore() {
        return store;
    }
}
