package com.xforceplus.ultraman.metadata.sync.grpc.store.impl;

import java.util.Objects;

/**
 * Bo Class hold id and name
 */
public class BoNode {

    private String code;

    private Long id;

    /**
     * bo start version
     */
    private int startGen;

    public BoNode(String code, Long id, int startGen) {
        this.code = code;
        this.id = id;
        this.startGen = startGen;
    }

    public BoNode(String code, Long id) {
        this.code = code;
        this.id = id;
    }

    public int getStartGen() {
        return startGen;
    }

    public void setStartGen(int startGen) {
        this.startGen = startGen;
    }

    public String getCode() {
        return code;
    }

    public Long getId() {
        return id;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        BoNode boNode = (BoNode) o;
        return Objects.equals(code, boNode.code) &&
                Objects.equals(id, boNode.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(code, id);
    }
}
